/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.xml;

import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlFactoryUtils {
    private static final DocumentBuilderFactory DEFAULT_DOCUMENT_BUILDER_FACTORY = XmlFactoryUtils.createSecureDocumentBuilderFactory();

    private XmlFactoryUtils() {
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        return XmlFactoryUtils.createSecureDocumentBuilderFactory(f -> {});
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory(Consumer<DocumentBuilderFactory> customizer) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            String feature = null;
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            factory.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setFeature(feature, false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            customizer.accept(factory);
            return factory;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static DocumentBuilder createSecureDocumentBuilder() {
        try {
            return DEFAULT_DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SAXParserFactory createSecureSAXParserFactory() {
        return XmlFactoryUtils.createSecureSAXParserFactory(f -> {});
    }

    public static SAXParserFactory createSecureSAXParserFactory(Consumer<SAXParserFactory> customizer) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            String feature = null;
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            factory.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setFeature(feature, false);
            factory.setXIncludeAware(false);
            customizer.accept(factory);
            return factory;
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static TransformerFactory createSecureTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }
}

