/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.validation;

import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.Severity;

public class MessageBuilder {
    private final Severity severity;
    private final String message;
    private String details;
    private int errorCode = -1;
    private Map<String, Object> properties;
    private String location = "";

    private MessageBuilder(String message, Severity severity) {
        this.severity = severity;
        this.message = message;
        this.properties = new HashMap<String, Object>();
    }

    public static MessageBuilder newInfoMessage(String message) {
        return MessageBuilder.newMessage(message, Severity.INFO);
    }

    public static MessageBuilder newErrorMessage(String message) {
        return MessageBuilder.newMessage(message, Severity.ERROR);
    }

    public static MessageBuilder newErrorMessage(String message, String location) {
        return MessageBuilder.newMessage(message, Severity.ERROR).withLocation(location);
    }

    public static MessageBuilder newWarningMessage(String message) {
        return MessageBuilder.newMessage(message, Severity.WARNING);
    }

    public static MessageBuilder newOtherMessage(String message) {
        return MessageBuilder.newMessage(message, Severity.OTHER);
    }

    public static MessageBuilder newMessage(String message, Severity severity) {
        return new MessageBuilder(message, severity);
    }

    public MessageBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public MessageBuilder withDetails(String details) {
        this.details = details;
        return this;
    }

    public MessageBuilder withErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public MessageBuilder withProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
        return this;
    }

    public Message build() {
        return new Message(this.message, this.severity, this.details, this.errorCode, this.properties, this.location);
    }
}

