/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.validation;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.tooling.core.validation.Severity;

public final class Message {
    private final String message;
    private final Severity severity;
    private final String details;
    private final int errorCode;
    private final Map<String, Object> properties;
    private String fieldLabel;

    Message(String message, Severity severity, String details, int errorCode, Map<String, Object> properties, String fieldLabel) {
        this.message = message;
        this.severity = severity;
        this.details = details;
        this.errorCode = errorCode;
        this.fieldLabel = fieldLabel;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDetails() {
        return this.details;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getFieldLabel() {
        return this.fieldLabel;
    }

    public <T> Optional<T> getProperty(String propertyName) {
        return Optional.ofNullable(this.properties.get(propertyName));
    }

    public boolean isErrorMessage() {
        return this.severity.equals((Object)Severity.ERROR);
    }

    public boolean isInfoMessage() {
        return this.severity.equals((Object)Severity.INFO);
    }

    public boolean isWarningMessage() {
        return this.severity.equals((Object)Severity.WARNING);
    }

    public boolean isOkMessage() {
        return this.severity.equals((Object)Severity.NONE);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.fieldLabel == null ? 0 : this.fieldLabel.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.fieldLabel == null ? other.fieldLabel != null : !this.fieldLabel.equals(other.fieldLabel)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.severity == other.severity;
    }
}

