/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.DOMFactory;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.MuleNamespaces;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.MuleConfigurationXmlGenerator;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;

public class XMLGeneratorVisitor
extends MessageFlowEntityVisitorAdapter {
    private IElementWrapper muleNode;
    private IMuleProject muleProject;
    private MuleConfiguration muleConfiguration;
    private IElementWrapper result;

    public XMLGeneratorVisitor() {
    }

    public IElementWrapper getResult() {
        return this.result;
    }

    public XMLGeneratorVisitor(MuleConfiguration muleConfiguration, IMuleProject muleProject) {
        this.muleConfiguration = muleConfiguration;
        this.muleProject = muleProject;
    }

    @Override
    public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processGlobalElement(globalUnknown, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    @Override
    public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
    }

    @Override
    public void visitEndpointNode(EndpointNode endpointNode) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processMessageFlowNode(endpointNode, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    @Override
    public void visitGlobalElement(GlobalElement globalElement) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processGlobalElement(globalElement, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    private void saveResult(IElementWrapper result) {
        this.result = result;
    }

    @Override
    public void visitPatternNode(PatternNode patternNode) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processMessageFlowNode(patternNode, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitSplitterNode(SplitterNode splitterNode) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processSplitter(splitterNode, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    @Override
    public void visitUnknownNode(UnknownNode unknownNode) {
        try {
            IFlowTransformerContext context = this.createContext();
            context.getDocumentWrapper().getRootElement().add(unknownNode.getElement());
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    @Override
    public void visitCommentNode(CommentContainer commentNode) {
        try {
            IFlowTransformerContext context = this.createContext();
            context.getDocumentWrapper().getRootElement().add(commentNode.getElement());
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating comment", e);
        }
    }

    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.muleConfiguration = muleConfiguration;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    private IFlowTransformerContext createContext() throws CoreException {
        IFlowTransformerContext tempContext = NewFlowTransformerContext.create(this.muleProject, this.getMuleConfiguration());
        IDocumentWrapper document = this.createMuleConfiguration(tempContext);
        return NewFlowTransformerContext.create(this.muleProject, document);
    }

    protected IDocumentWrapper createMuleConfiguration(IFlowTransformerContext context) throws CoreException {
        IDocumentWrapper documentWrapper = DOMFactory.newW3CDocumentWrapper(context.getMuleProject().getSchemaLocationLookup());
        this.muleNode = documentWrapper.createElement(MuleNamespaces.getMuleDefault(context.getMuleProject().getKind().getXmlRootNodeName()));
        IServerDefinition serverDefinition = CoreUtils.getServerDefinition(context);
        if (serverDefinition != null) {
            boolean isEnterprise = serverDefinition.isEnterpriseRuntime();
            this.muleNode.addAttribute("version", (isEnterprise ? "EE" : "CE") + "-" + serverDefinition.getVersion());
        }
        documentWrapper.add(this.muleNode);
        return documentWrapper;
    }

    @Override
    public void visitCompartment(Compartment compartment) {
    }

    @Override
    public void visitCompartmentLane(CompartmentLane lane) {
    }

    @Override
    public void visitContainer(Container container) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processContainer(container, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }

    @Override
    public void visitNestedContainer(NestedContainer nestedContainer) {
        try {
            IFlowTransformerContext context = this.createContext();
            MuleConfigurationXmlGenerator generator = new MuleConfigurationXmlGenerator();
            IElementWrapper element = generator.processDeferredNestedContainer(nestedContainer, context);
            context.getDocumentWrapper().getRootElement().add(element);
            this.saveResult(context.getDocumentWrapper().getRootElement());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Exception while generating documentation", e);
        }
    }
}

