/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.HashMap;
import java.util.Map;

public class VersionComparator {
    private static Map<String, VersionComparator> comparators = new HashMap<String, VersionComparator>();
    private String version;

    public VersionComparator(String version) {
        this.version = version;
    }

    public static VersionComparator forVersion(String version) {
        VersionComparator comparator;
        if (comparators.containsKey(version)) {
            comparator = comparators.get(version);
        } else {
            comparator = new VersionComparator(version);
            comparator.validate();
            comparators.put(version, comparator);
        }
        return comparator;
    }

    private void validate() {
        String[] thisVersionNumbers = this.getVersionNumbersArray(this.version);
        if (thisVersionNumbers.length == 0) {
            throw new IllegalArgumentException("Version: " + this.version + " is not a valid version");
        }
        String[] stringArray = thisVersionNumbers;
        int n = thisVersionNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            try {
                Integer.valueOf(segment);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Version: " + this.version + " is not a valid version");
            }
            ++n2;
        }
    }

    public int compareVersionTo(String otherVersion) {
        try {
            String[] otherVersionNumbers = this.getVersionNumbersArray(otherVersion);
            String[] thisVersionNumbers = this.getVersionNumbersArray(this.version);
            int minNumberOfQualifiers = Math.min(thisVersionNumbers.length, otherVersionNumbers.length);
            if (minNumberOfQualifiers == 0) {
                throw new IllegalArgumentException("Version: " + otherVersion + " is not a valid version");
            }
            int i = 0;
            while (i < minNumberOfQualifiers) {
                int otherQualifier;
                int thisQualifier = Integer.valueOf(thisVersionNumbers[i]);
                if (thisQualifier != (otherQualifier = Integer.valueOf(otherVersionNumbers[i]).intValue())) {
                    return thisQualifier - otherQualifier;
                }
                ++i;
            }
            if (thisVersionNumbers.length > otherVersionNumbers.length) {
                i = otherVersionNumbers.length;
                while (i < thisVersionNumbers.length) {
                    qualifier = Integer.valueOf(thisVersionNumbers[i]);
                    if (qualifier != 0) {
                        return qualifier;
                    }
                    ++i;
                }
            } else if (thisVersionNumbers.length < otherVersionNumbers.length) {
                i = thisVersionNumbers.length;
                while (i < otherVersionNumbers.length) {
                    qualifier = Integer.valueOf(otherVersionNumbers[i]);
                    if (qualifier != 0) {
                        return -qualifier;
                    }
                    ++i;
                }
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Version: " + otherVersion + " is not a valid version");
        }
    }

    private String[] getVersionNumbersArray(String version) {
        String versionUpToHyphen = null;
        int indexOfHyphen = version.indexOf("-");
        if (indexOfHyphen > 0) {
            versionUpToHyphen = version.substring(0, indexOfHyphen);
        } else if (indexOfHyphen == -1) {
            versionUpToHyphen = version;
        } else {
            throw new IllegalArgumentException("Version: " + version + " is not a valid version");
        }
        return versionUpToHyphen.split("\\.");
    }
}

