/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionManager;
import org.mule.tooling.core.mel.partitioner.EvaluatorValidator;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.DefaultEvaluatorConfiguration;
import org.mule.tooling.core.utils.TemplateParser;
import org.mule.tooling.core.utils.UnbalancedExpressionException;

public class ValidationUtils {
    public static final String PREFIX_EXPRESSION = Character.toString('#') + Character.toString('[');
    public static final String SUFFIX_EXPRESSION = Character.toString(']');
    public static final String DW_MISSING_SUFFIX_ERROR_MESSAGE = String.format("DataWeave expression must end with '%s'", SUFFIX_EXPRESSION);
    public static final String DW_UNBALANCED_EXPRESSION_ERROR_MESSAGE = String.format("DataWeave expression is unbalanced, check all quotes and braces have been closed properly.", new Object[0]);
    public static final Set<String> NODES_WITH_STRING_INTERPOLATION_SUPPORT = Stream.of("http://www.mulesoft.org/schema/mule/core/logger", "http://www.mulesoft.org/schema/mule/core/parse-template").collect(Collectors.toSet());
    public static final String COMPATIBILITY_MODULE_QUALIFIER = "com.mulesoft.mule.modules:mule-compatibility-module";
    private static final String PREFIX_MEL_EXPRESSION = "mel";
    private static final String ID = "org.mule.tooling.core.utils.ValidationUtils";
    final EvaluatorExtensionConfiguration configuration;
    final boolean supportsCompatibility;

    public ValidationUtils(IMuleProject muleProject) {
        this(new DefaultEvaluatorConfiguration(muleProject));
    }

    public ValidationUtils(EvaluatorExtensionConfiguration configuration) {
        this.configuration = configuration;
        this.supportsCompatibility = configuration.getProject().getDeclaredExtensions().stream().filter(extension -> extension.getQualifier().startsWith(COMPATIBILITY_MODULE_QUALIFIER)).findFirst().isPresent();
    }

    public IStatus validate(String text, String nodeDefinitionId) {
        IStatus result = Status.OK_STATUS;
        if (this.supportsStringInterpolation(nodeDefinitionId)) {
            try {
                List<String> templates = TemplateParser.parseMule(text);
                result = templates.stream().map(script -> this.doValidate((String)script)).filter(status -> !Status.OK_STATUS.equals(status)).findFirst().orElse(Status.OK_STATUS);
            }
            catch (UnbalancedExpressionException unbalancedExpressionException) {
                result = new Status(4, ID, DW_UNBALANCED_EXPRESSION_ERROR_MESSAGE);
            }
        } else {
            String scriptStr = text.trim();
            if (scriptStr.startsWith(PREFIX_EXPRESSION)) {
                if (scriptStr.endsWith(SUFFIX_EXPRESSION)) {
                    scriptStr = scriptStr.substring(PREFIX_EXPRESSION.length(), scriptStr.length() - SUFFIX_EXPRESSION.length());
                    result = this.doValidate(scriptStr);
                } else {
                    result = new Status(4, ID, DW_MISSING_SUFFIX_ERROR_MESSAGE);
                }
            }
        }
        return result;
    }

    private IStatus doValidate(String script) {
        IStatus result = Status.OK_STATUS;
        if (this.isDwExpression(script)) {
            EvaluatorValidator evaluator = EvaluatorExtensionManager.getInstance().getDefaultExpressionLanguageEvaluator().getValidator(this.configuration);
            result = evaluator.validate(script);
        } else {
            Optional<EvaluatorExtension> extension = EvaluatorExtensionManager.getInstance().getEvaluators().findExtensionForEvaluator(PREFIX_MEL_EXPRESSION);
            if (extension.isPresent()) {
                EvaluatorValidator validator = extension.get().getValidator(this.configuration);
                result = validator.validate(script);
            }
        }
        return result;
    }

    private boolean isDwExpression(String script) {
        return !this.supportsCompatibility || !script.startsWith("mel:");
    }

    private boolean supportsStringInterpolation(String nodeDefinitionId) {
        return NODES_WITH_STRING_INTERPOLATION_SUPPORT.contains(nodeDefinitionId);
    }
}

