/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;

public class VMUtils {
    public static final String JAVA_HOME = "JAVA_HOME";
    private static final String[] JDK_EXEC_FILES = new String[]{"javac", "javac.exe"};
    private static final String JVM_BIN_DIR = "bin";

    private VMUtils() {
    }

    public static String getDefaultJvmHome(IJavaProject project) {
        try {
            IVMInstall jvm = project != null ? JavaRuntime.getVMInstall((IJavaProject)project) : JavaRuntime.getDefaultVMInstall();
            return jvm.getInstallLocation().getAbsolutePath();
        }
        catch (Exception exception) {
            return System.getProperty(JAVA_HOME);
        }
    }

    public static List<IVMInstall> getAllJvmInstances() {
        ArrayList<IVMInstall> jvms = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                jvms.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return jvms;
    }

    public static String getJdkJavaHome() {
        IVMInstall defaultJvm = JavaRuntime.getDefaultVMInstall();
        if (VMUtils.isJdkJavaHome(defaultJvm.getInstallLocation().getAbsolutePath())) {
            return defaultJvm.getInstallLocation().getAbsolutePath();
        }
        for (IVMInstall jvm : VMUtils.getAllJvmInstances()) {
            if (!VMUtils.isJdkJavaHome(jvm.getInstallLocation().getAbsolutePath())) continue;
            return jvm.getInstallLocation().getAbsolutePath();
        }
        String javaHome = System.getenv(JAVA_HOME);
        if (StringUtils.isNotEmpty((String)javaHome) && VMUtils.isJdkJavaHome(javaHome)) {
            return javaHome;
        }
        return null;
    }

    public static boolean isJdkJavaHome(String javaHome) {
        File binDirectory = new File(javaHome, JVM_BIN_DIR);
        String[] stringArray = JDK_EXEC_FILES;
        int n = JDK_EXEC_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String jdkFile = stringArray[n2];
            File jdkExecFile = new File(binDirectory, jdkFile);
            if (jdkExecFile.exists() && jdkExecFile.isFile()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getVMArguments(IJavaProject project, String internalVMarguments) throws CoreException {
        IVMInstall jvm = project != null ? JavaRuntime.getVMInstall((IJavaProject)project) : JavaRuntime.getDefaultVMInstall();
        String[] internalArguments = DebugPlugin.parseArguments((String)internalVMarguments);
        if (jvm.getVMArguments() != null) {
            String[] stringArray = jvm.getVMArguments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String globalVMarg = stringArray[n2];
                if (!VMUtils.existsArgs(internalArguments, globalVMarg)) {
                    internalVMarguments = internalVMarguments.concat(" " + globalVMarg);
                }
                ++n2;
            }
        }
        return internalVMarguments;
    }

    private static boolean existsArgs(String[] internalArguments, String globalVMarg) {
        String arg = VMUtils.getKeyArgument(globalVMarg);
        return Stream.of(internalArguments).anyMatch(str -> str.contains(arg));
    }

    private static String getKeyArgument(String vMarg) {
        Matcher m = Pattern.compile("=|:[+]|:[-]").matcher(vMarg);
        while (m.find()) {
            String expression;
            switch (expression = m.group()) {
                case "=": {
                    int pos = m.start();
                    return vMarg.substring(0, pos);
                }
                case ":+": {
                    int pos = m.start();
                    return vMarg.substring(pos, vMarg.length());
                }
                case ":-": {
                    int pos = m.start();
                    return vMarg.substring(pos, vMarg.length());
                }
                case ":": {
                    int pos = m.start();
                    return vMarg.substring(0, pos);
                }
            }
        }
        return vMarg.contains(":") ? vMarg.substring(0, vMarg.indexOf(":")) : vMarg;
    }

    public static Optional<String> getJreVersion(IJavaProject muleProject) {
        try {
            IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)muleProject);
            return Optional.of(JavaModelUtil.getCompilerCompliance((IVMInstall2)((IVMInstall2)vm), null));
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem obtaining the jre of the project", e);
            return Optional.empty();
        }
    }
}

