/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class UrlSecurityCleaner {
    private String urlEndExpression;
    private String queryParameterDelimiter;
    private String queryParameterSeparator;

    private UrlSecurityCleaner(String endUrlExpression, String queryParameterDelimiter, String queryParameterSeparator) {
        this.urlEndExpression = endUrlExpression;
        this.queryParameterDelimiter = queryParameterDelimiter;
        this.queryParameterSeparator = queryParameterSeparator;
    }

    public String cleanUrl(String url, String ... params) {
        String domainUrl = StringUtils.substringBefore((String)url, (String)this.urlEndExpression);
        ArrayList urlTokens = Lists.newArrayList();
        if (!StringUtils.isEmpty((String)domainUrl)) {
            urlTokens.add(domainUrl);
            String onlyQueryParameters = StringUtils.substringAfter((String)url, (String)this.urlEndExpression);
            Map map = Splitter.on((String)this.queryParameterDelimiter).trimResults().withKeyValueSeparator(this.queryParameterSeparator).split((CharSequence)onlyQueryParameters);
            Arrays.asList(params).stream().forEach(p -> {
                String elemnt = map.getOrDefault(p, "");
                if (!StringUtils.isEmpty((String)elemnt)) {
                    urlTokens.add(p + "=" + elemnt);
                }
            });
        }
        return StringUtils.join((Object[])urlTokens.toArray());
    }

    public String cleanUrl(String url) {
        return this.cleanUrl(url, "");
    }

    public static class UrlSecurityCleanerBuilder {
        private String urlEndExpression;
        private String queryParameterDelimiter;
        private String queryParameterSeparator;

        public static UrlSecurityCleanerBuilder getInstance() {
            return new UrlSecurityCleanerBuilder();
        }

        public UrlSecurityCleanerBuilder withEndUrlExpression(String end) {
            this.urlEndExpression = end;
            return this;
        }

        public UrlSecurityCleanerBuilder withParameterDelimiter(String delimiter) {
            this.queryParameterDelimiter = delimiter;
            return this;
        }

        public UrlSecurityCleanerBuilder withParameterSeparator(String separator) {
            this.queryParameterSeparator = separator;
            return this;
        }

        public static UrlSecurityCleanerBuilder withDefaultExchangeDelimiters() {
            return new UrlSecurityCleanerBuilder().withEndUrlExpression("#!/").withParameterDelimiter("&").withParameterSeparator("=");
        }

        public UrlSecurityCleaner build() {
            UrlSecurityCleaner cleaner = new UrlSecurityCleaner(this.urlEndExpression, this.queryParameterDelimiter, this.queryParameterSeparator);
            return cleaner;
        }
    }
}

