/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.ExternalMuleUserLibraryClasspathContainer;

public class UpdatedMuleUserLibraryClasspathContainer
extends ExternalMuleUserLibraryClasspathContainer {
    private final IClasspathEntry[] updatedEntries;

    public UpdatedMuleUserLibraryClasspathContainer(ExternalContributionMuleModule extModule, IClasspathContainer originalContainer, IClasspathEntry[] newEntries) {
        super(extModule);
        this.updatedEntries = this.calculateEntries(newEntries, originalContainer);
    }

    private IClasspathEntry[] calculateEntries(IClasspathEntry[] newEntries, IClasspathContainer originalContainer) {
        IClasspathEntry[] originalEntries = originalContainer.getClasspathEntries();
        if (originalEntries != null && originalEntries.length > 0 && newEntries != null && newEntries.length == originalEntries.length) {
            int classpathEntryIndex = 0;
            while (classpathEntryIndex < originalEntries.length) {
                int newClasspathEntryIndex = 0;
                IClasspathEntry newEntry = null;
                IClasspathEntry originalEntry = originalEntries[classpathEntryIndex];
                while (newClasspathEntryIndex < newEntries.length) {
                    IClasspathEntry currentNewEntry = newEntries[newClasspathEntryIndex];
                    if (currentNewEntry.getPath().equals((Object)originalEntry.getPath())) {
                        newEntry = currentNewEntry;
                        break;
                    }
                    ++newClasspathEntryIndex;
                }
                if (newEntry != null && this.onlySourcesChanged(originalEntry, newEntry)) {
                    originalEntries[classpathEntryIndex] = newEntry;
                }
                ++classpathEntryIndex;
            }
        }
        return originalEntries;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        return this.updatedEntries;
    }

    private boolean onlySourcesChanged(IClasspathEntry originalEntry, IClasspathEntry newEntry) {
        return originalEntry.getPath().equals((Object)newEntry.getPath()) && originalEntry.getContentKind() == newEntry.getContentKind() && originalEntry.getEntryKind() == newEntry.getEntryKind() && newEntry.getSourceAttachmentPath() != null && !newEntry.getSourceAttachmentPath().equals((Object)originalEntry.getSourceAttachmentPath());
    }
}

