/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverFactory;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.artifact.dsl.request.DslSyntaxResolverFactoryRequest;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.icons.IconsResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.utils.ExtensionModelLoadException;
import org.mule.tooling.core.utils.ExtensionModelLoader;
import org.mule.tooling.core.utils.Tuple;
import org.mule.tooling.icons.IconsGenerator;

public class ToolingClientExtensionModelLoader
implements ExtensionModelLoader {
    private Tuple<ExtensionModel, DslSyntaxResolver> loadExtensionModel(MavenDependency plugin, ToolingRuntimeClient client) throws ExtensionModelLoadException {
        Optional extensionModel;
        DslSyntaxResolver extensionModelDslResolver;
        block6: {
            ExtensionModelService extensionModelService = client.extensionModelService();
            DslSyntaxResolverService dslSyntaxResolverService = client.dslSyntaxResolverService();
            ExtensionIconsService iconsService = client.iconsService();
            extensionModelDslResolver = null;
            long startModule = System.currentTimeMillis();
            String pluginGAV = MavenUtils.getGAV(plugin);
            try {
                ArtifactDescriptor artifact = ArtifactDescriptor.newBuilder().withGroupId(plugin.getGroupId()).withArtifactId(plugin.getArtifactId()).withVersion(plugin.getVersion()).withClassifier("mule-plugin").build();
                List<ArtifactDescriptor> artifacts = Arrays.asList(artifact);
                extensionModel = extensionModelService.loadExtensionModel(artifact);
                if (extensionModel.isPresent()) {
                    DslSyntaxResolverFactoryRequest dslSyntaxRequest = new DslSyntaxResolverFactoryRequest(artifacts);
                    DslSyntaxResolverFactory dslSyntaxResolverFactory = dslSyntaxResolverService.getDslSyntaxResolverFactory(dslSyntaxRequest);
                    extensionModelDslResolver = dslSyntaxResolverFactory.createDslResolver((ExtensionModel)extensionModel.get());
                    IconsResult extensionIcons = iconsService.getIconsFor(artifact);
                    extensionIcons.getExtensionIcon().ifPresent(iconData -> this.storeIconData(artifact, "", (byte[])iconData));
                    extensionIcons.getAdditionalIcons().entrySet().forEach(entry -> this.storeIconData(artifact, (String)entry.getKey(), (byte[])entry.getValue()));
                    extensionModelService.loadExtensionSchema(artifact).ifPresent(schemaContent -> this.storeSchemaData(artifact, ((ExtensionModel)extensionModel.get()).getXmlDslModel().getXsdFileName(), (String)schemaContent));
                    break block6;
                }
                return null;
            }
            catch (Throwable ex) {
                throw new ExtensionModelLoadException("Unexpected error loading extension from: " + pluginGAV, ex);
            }
            finally {
                long endModule = System.currentTimeMillis();
                System.out.println("Plugin " + pluginGAV + ": " + (endModule - startModule));
            }
        }
        DslSyntaxResolver extensionModelDslResolverPair = extensionModelDslResolver;
        return extensionModel.map(model -> new Tuple<ExtensionModel, DslSyntaxResolver>((ExtensionModel)model, extensionModelDslResolverPair)).orElse(null);
    }

    private void storeIconData(ArtifactDescriptor artifact, String key, byte[] iconData) {
        File file = this.getOrCreateArtifactAssetsRootDir(artifact);
        File originalIconFile = new File(file, StringUtils.isEmpty((CharSequence)key) ? "icon.svg" : key);
        this.writeBytesToFile(originalIconFile, iconData);
        this.saveIcon(iconData, 16, this.getPaletteIconFileName(key), file);
        this.saveIcon(iconData, 32, this.getHighResPaletteIconFileName(key), file);
        this.saveIcon(iconData, 64, this.getCanvasIconFilename(key), file);
        this.saveIcon(iconData, 128, this.getHighResIconFilename(key), file);
    }

    private void storeSchemaData(ArtifactDescriptor artifact, String schemaFileName, String schemaContent) {
        File file = this.getOrCreateArtifactAssetsRootDir(artifact);
        File schemaFile = new File(file, schemaFileName);
        byte[] schemaBytes = schemaContent.getBytes();
        this.writeBytesToFile(schemaFile, schemaBytes);
    }

    private void writeBytesToFile(File targetFile, byte[] content) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fileStream = new FileOutputStream(targetFile);){
                fileStream.write(content);
                fileStream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            MuleCorePlugin.logWarning("Unexpected writing data", ex);
        }
    }

    private File getOrCreateArtifactAssetsRootDir(ArtifactDescriptor artifact) {
        Path artifactPathInCache = this.getPathCacheForArtifact(artifact);
        File file = artifactPathInCache.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private Path getPathCacheForArtifact(ArtifactDescriptor artifact) {
        Path baseDir = ToolingCachePathUtils.getEditorsCachePath().toFile().toPath();
        String groupId = artifact.getGroupId();
        String[] split = groupId.split("\\.");
        List<String> groupIdParts = Arrays.asList(split);
        for (String part : groupIdParts) {
            baseDir = baseDir.resolve(part);
        }
        return baseDir.resolve(artifact.getArtifactId()).resolve(artifact.getVersion());
    }

    private String getPaletteIconFileName(String key) {
        return key.replace(".svg", "-") + "palette-icon.png";
    }

    private String getHighResPaletteIconFileName(String key) {
        return key.replace(".svg", "-") + "palette-icon@2x.png";
    }

    private String getCanvasIconFilename(String key) {
        return key.replace(".svg", "-") + "canvas-icon.png";
    }

    private String getHighResIconFilename(String key) {
        return key.replace(".svg", "-") + "canvas-icon@2x.png";
    }

    private void saveIcon(byte[] iconData, int size, String fileName, File parentFolder) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ByteArrayInputStream data = new ByteArrayInputStream(iconData);){
                File hd = new File(parentFolder, fileName);
                if (!hd.exists()) {
                    ((IconsGenerator)MuleCorePlugin.getStudioContext().get(IconsGenerator.class)).toPng(size, size, data, hd.toPath());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            MuleCorePlugin.logWarning("Unexpected error storing icon data", ex);
        }
    }

    @Override
    public Optional<Tuple<ExtensionModel, DslSyntaxResolver>> getExtensionModel(MavenDependency plugin, ToolingRuntimeClient client) throws ExtensionModelLoadException {
        return Optional.ofNullable(this.loadExtensionModel(plugin, client));
    }
}

