/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TimingUtils {
    public static <T> T dumpTiming(Supplier<T> computation, Supplier<String> messageSupplier, Consumer<String> printer) {
        long before = System.nanoTime();
        T value = computation.get();
        long after = System.nanoTime();
        TimingUtils.dumpTiming(before, after, messageSupplier, printer);
        return value;
    }

    public static void dumpTiming(long before, long after, Supplier<String> messageSupplier, Consumer<String> printer) {
        TimingUtils.dumpTiming(before, after, messageSupplier, TimingUtils::formatMessage, printer);
    }

    public static void dumpTiming(long before, long after, Supplier<String> messageSupplier, Function<String, String> formatter, Consumer<String> printer) {
        long delta = after - before;
        double inMillis = (double)delta / 1000000.0;
        StringBuffer indicator = new StringBuffer();
        while (delta > 0L) {
            indicator.append("*");
            delta /= 1000L;
        }
        String messageFormat = "{0}: {1} {2}";
        String message = MessageFormat.format(messageFormat, messageSupplier.get(), inMillis + "ms", indicator);
        TimingUtils.dumpMessage(message, formatter, printer);
    }

    public static void dumpMessage(String message) {
        TimingUtils.dumpMessage(message, null);
    }

    public static void dumpMessage(String message, Consumer<String> printer) {
        TimingUtils.dumpMessage(message, TimingUtils::formatMessage, printer);
    }

    public static void dumpMessage(String message, Function<String, String> formatter, Consumer<String> printer) {
        String formattedMessage = formatter.apply(message);
        Optional.ofNullable(printer).orElse(System.out::println).accept(formattedMessage);
    }

    private static String formatMessage(String message) {
        return MessageFormat.format("{0}: {1} - {2}", Thread.currentThread(), LocalDateTime.now(), message);
    }

    public static class Stats {
        private int invocations;
        private long totalTime;
        private String label;

        public Stats(String label) {
            this.label = label;
        }

        public <T> T evaluate(Supplier<T> computation) {
            return this.evaluate(computation, 500, null, null);
        }

        public <T> T evaluate(Supplier<T> computation, int multiple, Supplier<String> messageSupplier, Consumer<String> printer) {
            return this.evaluate(computation, () -> this.invocations % multiple == 0, messageSupplier, printer);
        }

        public <T> T evaluate(Supplier<T> computation, Supplier<Boolean> showTiming, Supplier<String> messageSupplier, Consumer<String> printer) {
            long before = System.nanoTime();
            T value = computation.get();
            long after = System.nanoTime();
            this.totalTime += after - before;
            ++this.invocations;
            if (showTiming.get().booleanValue()) {
                TimingUtils.dumpMessage(Optional.ofNullable(messageSupplier).orElse(this::toString).get(), Function.identity(), printer);
            }
            return value;
        }

        public int getInvocations() {
            return this.invocations;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public double getAverage() {
            return (double)this.totalTime / (double)this.invocations;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label + " - invocations: " + this.invocations + " - totalTime: " + this.totalTime + " - average: " + this.getAverage();
        }
    }
}

