/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.utils.UnbalancedExpressionException;

public class TemplateParser {
    private static final char CHAR_DOUBLE_QUOTE = '\"';
    private static final char CHAR_BACK_SLASH = '\\';
    private static final char CHAR_SINGLE_QUOTE = '\'';
    public static final char START_EXPRESSION = '#';
    public static final char OPEN_EXPRESSION = '[';
    public static final char CLOSE_EXPRESSION = ']';
    private static final char INIT_COMMENT = '/';
    private static final char ASTERISK = '*';
    private static final char BREAKLINE = '\n';
    private static boolean supportsNestedExpressions = true;

    public static List<String> parseMule(String script) throws UnbalancedExpressionException {
        ArrayList<String> expressions = new ArrayList<String>();
        StringBuilder expressionBuilder = new StringBuilder();
        boolean isStartOfExpression = false;
        boolean isStartOfComment = false;
        boolean isEndOfComment = false;
        boolean isEscaped = false;
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        boolean skipChar = false;
        boolean isSimpleComment = false;
        boolean isMultipleLineComment = false;
        int openBraces = 0;
        int i = 0;
        while (i < script.length()) {
            char c = script.charAt(i);
            switch (c) {
                case '\\': {
                    isEscaped = !isEscaped;
                    break;
                }
                case '\'': {
                    if (isEscaped || openBraces <= 0 || isMultipleLineComment || isSimpleComment) break;
                    insideSingleQuotes = !insideSingleQuotes;
                    break;
                }
                case '\"': {
                    if (isEscaped || openBraces <= 0 || isMultipleLineComment || isSimpleComment) break;
                    insideDoubleQuotes = !insideDoubleQuotes;
                    break;
                }
                case ']': {
                    if (openBraces <= 0 || insideSingleQuotes || insideDoubleQuotes || isMultipleLineComment || isSimpleComment) break;
                    --openBraces;
                    break;
                }
                case '[': {
                    if (!isStartOfExpression && openBraces <= 0 || insideSingleQuotes || insideDoubleQuotes || isMultipleLineComment || isSimpleComment || ++openBraces != 1) break;
                    skipChar = true;
                    break;
                }
                case '/': {
                    if (openBraces > 0 && isStartOfComment && !insideSingleQuotes && !insideDoubleQuotes) {
                        isSimpleComment = true;
                        break;
                    }
                    if (openBraces <= 0 || !isEndOfComment || insideSingleQuotes || insideDoubleQuotes) break;
                    isMultipleLineComment = false;
                    break;
                }
                case '*': {
                    if (openBraces <= 0 || !isStartOfComment || insideSingleQuotes || insideDoubleQuotes) break;
                    isMultipleLineComment = true;
                    break;
                }
                case '\n': {
                    if (openBraces <= 0 || !isSimpleComment || insideSingleQuotes || insideDoubleQuotes) break;
                    isSimpleComment = false;
                }
            }
            if (openBraces > 0) {
                if (!skipChar) {
                    expressionBuilder.append(c);
                } else {
                    skipChar = false;
                }
            } else if (openBraces == 0 && expressionBuilder.length() > 0) {
                expressions.add(expressionBuilder.toString());
                expressionBuilder = new StringBuilder();
            }
            isStartOfExpression = c == '#';
            isStartOfComment = c == '/';
            isEndOfComment = c == '*';
            isEscaped = c == '\\';
            ++i;
        }
        if (insideSingleQuotes || insideDoubleQuotes || openBraces > 0) {
            throw new UnbalancedExpressionException();
        }
        if (expressionBuilder.length() > 0) {
            expressions.add(expressionBuilder.toString());
        }
        if (supportsNestedExpressions) {
            ArrayList<String> nestedExpressions = new ArrayList<String>();
            for (String expression : expressions) {
                try {
                    nestedExpressions.addAll(TemplateParser.parseMule(expression));
                }
                catch (UnbalancedExpressionException unbalancedExpressionException) {}
            }
            expressions.addAll(nestedExpressions);
        }
        return expressions;
    }

    public static void supportsNestedExpressions(boolean b) {
        supportsNestedExpressions = b;
    }
}

