/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.mule.tooling.core.io.CopyFileVisitor;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class StudioFileUtils {
    private StudioFileUtils() {
        throw new IllegalCreationException();
    }

    public static File getTempFileAt(String basePath, String filename) {
        File result = StudioFileUtils.getTempDirectory();
        result = new File(result, basePath);
        result.mkdirs();
        return new File(result, filename);
    }

    public static File getTempDirectory() {
        File tempDirLocation = SystemUtils.getJavaIoTmpDir();
        if (tempDirLocation != null && tempDirLocation.exists() && tempDirLocation.canWrite()) {
            return tempDirLocation;
        }
        File workspaceTempDir = StudioFileUtils.getWorkspaceTempLocation();
        if (workspaceTempDir.exists() && workspaceTempDir.canWrite()) {
            return workspaceTempDir;
        }
        return SystemUtils.getUserDir();
    }

    public static File getWorkspaceTempLocation() {
        File tempFolder;
        File root = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File muleFolder = new File(root, ".mule");
        if (!muleFolder.exists()) {
            muleFolder.mkdir();
        }
        if (!(tempFolder = new File(root, "temp")).exists()) {
            tempFolder.mkdir();
        }
        return tempFolder;
    }

    public static File calculateTempPath() {
        return StudioFileUtils.calculateTempPath("tmp");
    }

    public static File calculateTempPath(String extension) {
        File tempDir = StudioFileUtils.getTempDirectory();
        String filename = UUID.randomUUID().toString() + "." + extension;
        return new File(tempDir, filename);
    }

    public static void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("copyFiles: Can not find source: " + src.getAbsolutePath() + ".");
        }
        if (!src.canRead()) {
            throw new IOException("copyFiles: No right to source: " + src.getAbsolutePath() + ".");
        }
        Files.walkFileTree(src.toPath(), new CopyFileVisitor(dest.toPath()));
    }

    public static void deleteDirectoriesFromTempDirectory(final String name) {
        try {
            Collection directories = FileUtils.listFilesAndDirs((File)FileUtils.getTempDirectory(), (IOFileFilter)FalseFileFilter.INSTANCE, (IOFileFilter)new IOFileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith(name);
                }

                public boolean accept(File dir, String dirname) {
                    return dirname.startsWith(name);
                }
            });
            directories.remove(FileUtils.getTempDirectory());
            ((Stream)directories.stream().parallel()).forEach(directory -> {
                try {
                    FileUtils.forceDelete((File)directory);
                }
                catch (Exception exception) {}
            });
        }
        catch (Exception exception) {}
    }
}

