/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;

public class StartsWithSearchingMap<T> {
    protected TreeMap<String, T> treeMap = new TreeMap();
    protected List<String> orderedKeyList = new ArrayList<String>();
    private Comparator<? super String> startsWithComparator = new StartsWithComparator();

    public void put(String key, T value) {
        if (value == null) {
            this.treeMap.remove(key);
        } else {
            this.treeMap.put(key, value);
        }
        this.orderedKeyList = new ArrayList<String>(this.treeMap.keySet());
    }

    public boolean contains(String namespace) {
        int binarySearchResult = this.search(namespace);
        return binarySearchResult >= 0;
    }

    public T get(String searchKey) {
        int binarySearchResult = this.search(searchKey);
        if (binarySearchResult < 0) {
            throw new IllegalArgumentException("Key " + searchKey + " is not contained in this map. Please call contains(String) before calling this method");
        }
        String key = this.orderedKeyList.get(binarySearchResult);
        T value = this.treeMap.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Apparently existant key " + key + " returned a null value");
        }
        return value;
    }

    private int search(String namespace) {
        return Collections.binarySearch(this.orderedKeyList, namespace, this.startsWithComparator);
    }

    private class StartsWithComparator
    implements Comparator<String> {
        private StartsWithComparator() {
        }

        @Override
        public int compare(String aString, String otherString) {
            if (otherString.startsWith(aString) || aString.startsWith(otherString)) {
                return 0;
            }
            return aString.compareTo(otherString);
        }
    }
}

