/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;

public class ProjectUtils {
    public static final String RESOURCES_FOR_EXPERIMENTAL_DATASENSE = "experimental.datasense.resources.selected";
    public static final String USE_EXPERIMENTAL_DATASENSE = "experimental.datasense.enabled";

    private ProjectUtils() {
    }

    public static Optional<IProject> getIProjectFromSelection(ISelection selection) {
        Optional<IProject> result = Optional.empty();
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof IProject) {
                result = Optional.of((IProject)firstElement);
            } else if (firstElement instanceof IJavaProject) {
                result = Optional.of(((IJavaProject)firstElement).getProject());
            }
        }
        return result;
    }

    public static boolean shouldResolveDataSenseWithDependencyResources(IMuleProject muleProject) {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(muleProject.getProject()), "org.mule.tooling.core");
        return preferenceStore.getBoolean(USE_EXPERIMENTAL_DATASENSE);
    }

    public static List<ExternalContributionMuleModule> getDependenciesForExperimentalDataSense(IMuleProject muleProject) {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(muleProject.getProject()), "org.mule.tooling.core");
        String selectedResources = preferenceStore.getString(RESOURCES_FOR_EXPERIMENTAL_DATASENSE);
        if (selectedResources.isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<ExternalContributionMuleModule> result = new ArrayList<ExternalContributionMuleModule>();
        String[] resourcesAsArray = selectedResources.split(",");
        int index = 0;
        while (index < resourcesAsArray.length) {
            for (ExternalContributionMuleModule module : muleProject.getModuleManager().getExternalModules()) {
                MavenCoordinates moduleCoords = module.getCoordinates();
                String[] resourceGA = resourcesAsArray[index].split(":");
                if (!moduleCoords.getGroupId().equals(resourceGA[0]) || !moduleCoords.getArtifactId().equals(resourceGA[1])) continue;
                result.add(module);
                break;
            }
            ++index;
        }
        return result;
    }

    public static void setExperimentalDataSensePrefs(IMuleProject muleProject, boolean useExperimentalDataSense, Object[] selectedModules) {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(muleProject.getProject()), "org.mule.tooling.core");
        StringBuilder valueToSave = new StringBuilder();
        int index = 0;
        while (index < selectedModules.length) {
            if (index > 0) {
                valueToSave.append(",");
            }
            ExternalContributionMuleModule module = (ExternalContributionMuleModule)selectedModules[index];
            MavenCoordinates coords = module.getCoordinates();
            valueToSave.append(coords.getGroupId());
            valueToSave.append(":");
            valueToSave.append(coords.getArtifactId());
            ++index;
        }
        preferenceStore.setValue(USE_EXPERIMENTAL_DATASENSE, useExperimentalDataSense);
        preferenceStore.setValue(RESOURCES_FOR_EXPERIMENTAL_DATASENSE, valueToSave.toString());
    }
}

