/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.ProjectStructureContribution;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class ProjectStructureContributionManager {
    private static final EditingScope DEFAULT_SCOPE = EditingScope.APP;
    private static ProjectStructureContributionManager defaultInstance;
    private Collection<ProjectStructureContribution> contributions;
    private Collection<ProjectStructureContribution> runtimeContributions;
    private Map<String, ProjectStructureContribution> idContributionMap;
    private Map<String, EditingScope> nameToScopeCache;

    public static ProjectStructureContributionManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProjectStructureContributionManager();
        }
        return defaultInstance;
    }

    public ProjectStructureContributionManager() {
        this.init();
    }

    private void init() {
        this.contributions = new ArrayList<ProjectStructureContribution>();
        this.runtimeContributions = new ArrayList<ProjectStructureContribution>();
        this.idContributionMap = new HashMap<String, ProjectStructureContribution>();
        this.nameToScopeCache = new HashMap<String, EditingScope>();
        this.nameToScopeCache.put(EditingScope.APP.getName(), EditingScope.APP);
        this.nameToScopeCache.put(EditingScope.TEST.getName(), EditingScope.TEST);
        IExtensionPointReader extensionPointReader = IExtensionPointReader.create(ProjectStructureContribution.class);
        for (ProjectStructureContribution contribution : extensionPointReader.readAll()) {
            this.contributions.add(contribution);
            this.idContributionMap.put(contribution.getId(), contribution);
            contribution.getScope().filter(scope -> !this.nameToScopeCache.containsKey(scope.getName())).ifPresent(scope -> this.nameToScopeCache.put(scope.getName(), (EditingScope)scope));
            if (!contribution.isAddToMuleRuntime()) continue;
            this.runtimeContributions.add(contribution);
        }
    }

    public Collection<ProjectStructureContribution> getContributions() {
        return this.contributions;
    }

    public Collection<ProjectStructureContribution> getRuntimeContributions() {
        return this.runtimeContributions;
    }

    public ProjectStructureContribution getContribution(String id) {
        return this.idContributionMap.get(id);
    }

    public static List<File> getContributedFilesIn(IMuleProject muleProject, ProjectStructureContribution contribution) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            IFolder folder = muleProject.getFolder(contribution.getFolderPath());
            Collection<String> fileTypes = contribution.getFileTypes();
            if (folder.exists()) {
                if (fileTypes != null && !fileTypes.isEmpty()) {
                    for (String fileType : fileTypes) {
                        files.addAll(CoreUtils.listFiles(folder, fileType));
                    }
                } else {
                    IResource[] iResourceArray = folder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource iResource = iResourceArray[n2];
                        files.add(iResource.getLocation().toFile());
                        ++n2;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return files;
    }

    public static Map<ProjectStructureContribution, Collection<File>> getContributedFiles(IMuleProject muleProject) throws CoreException {
        HashMap<ProjectStructureContribution, Collection<File>> map = new HashMap<ProjectStructureContribution, Collection<File>>();
        Collection<ProjectStructureContribution> contributions = ProjectStructureContributionManager.getDefault().getRuntimeContributions();
        for (ProjectStructureContribution contribution : contributions) {
            List<File> contributedFiles = ProjectStructureContributionManager.getContributedFilesIn(muleProject, contribution);
            map.put(contribution, contributedFiles);
        }
        return map;
    }

    public Optional<ProjectStructureContribution> getContributionByResource(IResource resource) {
        return this.getContributions().stream().filter(projectContribution -> resource.getProjectRelativePath().toString().startsWith(projectContribution.getFolderPath())).findFirst();
    }

    public Optional<EditingScope> getScope(String name) {
        return Optional.ofNullable(this.nameToScopeCache.get(name));
    }

    public EditingScope getScope(IResource resource) {
        Optional<ProjectStructureContribution> contributionFromResource = ProjectStructureContributionManager.getDefault().getContributionByResource(resource);
        return contributionFromResource.map(projectStructure -> projectStructure.getScope().orElse(this.inferScopeFromPath(resource))).orElse(this.inferScopeFromPath(resource));
    }

    private EditingScope inferScopeFromPath(IResource resource) {
        EditingScope scope = Path.EMPTY.append("src").append("test").isPrefixOf(resource.getProjectRelativePath()) ? EditingScope.TEST : DEFAULT_SCOPE;
        return scope;
    }
}

