/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.action.ProjectLifecycleAction;
import org.mule.tooling.core.packageManager.PostImportActionContribution;

public class ProjectLifecycleContributionManager {
    private static final String ATTRIBUTE_START_LEVEL = "startLevel";
    private static final int DEFAULT_START_LEVEL = 10;
    private static ProjectLifecycleContributionManager instance;
    private ArrayList<PostImportActionContribution> postImportActionContributions;

    private ProjectLifecycleContributionManager() {
    }

    public static ProjectLifecycleContributionManager getInstance() {
        if (instance == null) {
            instance = new ProjectLifecycleContributionManager();
        }
        return instance;
    }

    private void initializePostImportActionContributions() {
        IConfigurationElement[] configurationElements;
        this.postImportActionContributions = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.core.postImportActions");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                ProjectLifecycleAction postImportAction = (ProjectLifecycleAction)configurationElement.createExecutableExtension("class");
                String startLevel = configurationElement.getAttribute(ATTRIBUTE_START_LEVEL);
                PostImportActionContribution contribution = new PostImportActionContribution();
                if (startLevel != null) {
                    contribution.setLevel(Integer.valueOf(startLevel));
                } else {
                    contribution.setLevel(10);
                }
                contribution.setProjectLifecycleAction(postImportAction);
                this.postImportActionContributions.add(contribution);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error instantiating post-initialize-actions", e);
                e.printStackTrace();
            }
            ++n2;
        }
        Collections.sort(this.postImportActionContributions, new PostImportActionContributionComparator());
    }

    public List<ProjectLifecycleAction> getPostImportActions() {
        if (this.postImportActionContributions == null) {
            this.initializePostImportActionContributions();
        }
        ArrayList<ProjectLifecycleAction> postImportActions = new ArrayList<ProjectLifecycleAction>();
        for (PostImportActionContribution actionContribution : this.postImportActionContributions) {
            postImportActions.add(actionContribution.getProjectLifecycleAction());
        }
        return postImportActions;
    }

    private class PostImportActionContributionComparator
    implements Comparator<PostImportActionContribution> {
        private PostImportActionContributionComparator() {
        }

        @Override
        public int compare(PostImportActionContribution o1, PostImportActionContribution o2) {
            return Integer.valueOf(o1.getLevel()).compareTo(o2.getLevel());
        }
    }
}

