/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.utils.Messages;

public class ProjectLibsClasspathContainer
implements IClasspathContainer {
    public static final String CONTAINER_NAME = Messages.PROJECT_LIBS_CONTAINER_DESCRIPTION;
    public static final String MULE_PROJECT_LIB_PREFIX = "org.mule.tooling.MULE_PROJECT_LIB";
    private final IClasspathEntry[] entries;

    public ProjectLibsClasspathContainer() {
        this.entries = new IClasspathEntry[0];
    }

    public ProjectLibsClasspathContainer(IClasspathEntry[] entries) {
        this.entries = entries;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    public String getDescription() {
        return CONTAINER_NAME;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path(MULE_PROJECT_LIB_PREFIX);
    }

    public static boolean hasProjectLibsClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return false;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        boolean isMuleRuntime = false;
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            isMuleRuntime |= entry.getPath().segment(0).equals(MULE_PROJECT_LIB_PREFIX);
            ++n2;
        }
        return isMuleRuntime;
    }
}

