/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;

public class MuleUserLibraryClasspathContainer
implements IClasspathContainer {
    public static final String MULE_LIB_PREFIX = "MULE_LIB";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    private String name;

    public MuleUserLibraryClasspathContainer(String name) {
        this.name = MuleUserLibraryClasspathContainer.getContainerPathQualifier(name);
    }

    public IClasspathEntry[] getClasspathEntries() {
        return null;
    }

    public String getDescription() {
        return this.name;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return MuleUserLibraryClasspathContainer.getContainerPath(this.name);
    }

    public static String getCoordinatesFromPath(IPath containerPath) {
        StringBuilder coordinatesBuilder = new StringBuilder(containerPath.segment(1));
        String[] stringArray = containerPath.removeFirstSegments(2).segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            coordinatesBuilder.append(":");
            coordinatesBuilder.append(segment);
            ++n2;
        }
        return coordinatesBuilder.toString();
    }

    public static boolean isMuleLibrary(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return path.segmentCount() > 0 && MULE_LIB_PREFIX.equals(path.segment(0));
    }

    public static IPath getContainerPath(String name) {
        return new Path("MULE_LIB/" + MuleUserLibraryClasspathContainer.getContainerPathQualifier(name));
    }

    private static String getContainerPathQualifier(String name) {
        return name.replaceAll(":", PATH_SEPARATOR);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MuleUserLibraryClasspathContainer other = (MuleUserLibraryClasspathContainer)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

