/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.io.MuleResourceUtils;

public abstract class MuleProjectResourceVisitor
implements IResourceVisitor {
    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            this.visitFile((IFile)resource);
        }
        boolean keepVisiting = resource instanceof IContainer && this.couldLeadToMuleConfigPath(resource) || resource instanceof IProject;
        return keepVisiting;
    }

    public abstract void visitFile(IFile var1) throws CoreException;

    private boolean couldLeadToMuleConfigPath(IResource resource) {
        List<IPath> muleConfigPaths = MuleResourceUtils.getMuleConfigPaths();
        IPath resourcePath = resource.getProjectRelativePath();
        boolean isValid = false;
        for (IPath path : muleConfigPaths) {
            if (!resourcePath.isPrefixOf(path) && !path.isPrefixOf(resourcePath)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }
}

