/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.settings.Settings;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.MuleMavenClient;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.RepositoryFactory;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMavenRepositoriesProvider;

public class MavenClientFactory {
    public static MuleMavenClient getMavenClient(IMavenRepositoriesProvider muleProject) {
        MavenConfiguration configuration = MavenClientFactory.getConfiguration(muleProject, MavenCore.newUserMavenConfiguration(), MavenCore.getUserSettings());
        MuleMavenClient muleMavenClient = new MuleMavenClient(configuration);
        return muleMavenClient;
    }

    public static MavenConfiguration getConfiguration(IMavenRepositoriesProvider muleProject, MavenConfiguration baseConfiguration, Settings settings) {
        MavenConfiguration.MavenConfigurationBuilder builder = new MavenConfiguration.MavenConfigurationBuilder();
        baseConfiguration.getMavenRemoteRepositories().stream().forEach(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).remoteRepository(arg_0));
        muleProject.getProjectRepositories().stream().map(x -> MavenCore.getRemoteRepository(settings, x)).map(repo -> MavenClientFactory.createRepository(repo)).filter(Objects::nonNull).forEach(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).remoteRepository(arg_0));
        builder.localMavenRepositoryLocation(baseConfiguration.getLocalMavenRepositoryLocation());
        builder.forcePolicyUpdateAlways(baseConfiguration.getForcePolicyUpdateAlways());
        builder.forcePolicyUpdateNever(baseConfiguration.getForcePolicyUpdateNever());
        baseConfiguration.getUserSettingsLocation().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).userSettingsLocation(arg_0));
        baseConfiguration.getGlobalSettingsLocation().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).globalSettingsLocation(arg_0));
        baseConfiguration.getSettingsSecurityLocation().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).settingsSecurityLocation(arg_0));
        builder.ignoreArtifactDescriptorRepositories(baseConfiguration.getIgnoreArtifactDescriptorRepositories());
        builder.offlineMode(baseConfiguration.getOfflineMode());
        return builder.build();
    }

    private static RemoteRepository createRepository(org.eclipse.aether.repository.RemoteRepository repo) {
        URL url = MavenClientFactory.getUrl(repo);
        return Optional.ofNullable(url).map(url1 -> new RemoteRepository.RemoteRepositoryBuilder().id(repo.getId()).url(url1).releasePolicy(Optional.ofNullable(repo.getPolicy(false)).map(policy -> RepositoryFactory.toPolicy(policy)).orElse(RepositoryFactory.getDefaultReleasePolicy())).snapshotPolicy(Optional.ofNullable(repo.getPolicy(true)).map(policy -> RepositoryFactory.toPolicy(policy)).orElse(RepositoryFactory.getDefaultSnapshotPolicy())).build()).orElse(null);
    }

    public static URL getUrl(org.eclipse.aether.repository.RemoteRepository repo) {
        try {
            return new URL(repo.getUrl());
        }
        catch (MalformedURLException e) {
            MuleCorePlugin.logError("Invalid URL: " + repo.getUrl(), e);
            return null;
        }
    }
}

