/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.mule.tooling.utils.SilentRunner;

public class JobUtils {
    public static void waitUntilJobGroupEnds(final JobGroup group, final long timeout, final Runnable callback) {
        if (group != null) {
            new Thread("Job Group Watcher"){

                @Override
                public void run() {
                    try {
                        group.join(timeout, null);
                        callback.run();
                    }
                    catch (InterruptedException | OperationCanceledException throwable) {}
                }
            }.start();
        } else {
            callback.run();
        }
    }

    public static void waitUntillValidationJobEnds(String jobName, final Callable<Void> callback) {
        final Job result = JobUtils.findJobByName(jobName, Optional.of(4));
        if (result != null) {
            new Thread("Job Watcher"){

                @Override
                public void run() {
                    int retry = 50;
                    while (retry < 50 && JobUtils.isRunning(result)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++retry;
                    }
                    result.cancel();
                    SilentRunner.run((Callable)callback, null);
                }
            }.start();
        } else {
            SilentRunner.run(callback, null);
        }
    }

    public static Job findJobByName(String jobName, Optional<Integer> state) {
        Job[] allJobs;
        Job result = null;
        IJobManager jobMan = Job.getJobManager();
        Job[] jobArray = allJobs = jobMan.find(null);
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().equals(jobName) && (!state.isPresent() || job.getState() == state.get().intValue())) {
                result = job;
                break;
            }
            ++n2;
        }
        return result;
    }

    protected static boolean isRunning(Job job) {
        return job.getState() == 4;
    }

    public static void cancelJob(String jobName) {
        Job job = JobUtils.findJobByName(jobName, Optional.empty());
        if (job != null) {
            job.cancel();
        }
    }

    public static void rescheduleJob(String jobName, long delay) {
        Job job = JobUtils.findJobByName(jobName, Optional.empty());
        if (job != null && !JobUtils.isRunning(job) && job.cancel()) {
            job.schedule(delay);
        }
    }

    public static <T> void schedule(String jobName, final Function<IProgressMonitor, T> work, long delay, Consumer<Job> configurer) {
        Job newJob = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                Object result = work.apply(monitor);
                return result instanceof IStatus ? (IStatus)result : Status.OK_STATUS;
            }
        };
        configurer.accept(newJob);
        newJob.schedule(delay);
    }

    public static JobGroup createJobGroup(String name, int maxThreads) {
        return JobUtils.createJobGroup(name, maxThreads, 0, false);
    }

    public static JobGroup createJobGroup(String name, int maxThreads, int seedJobsCount, final boolean cancelOnFirstFailure) {
        return new JobGroup(name, maxThreads, seedJobsCount){

            protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCanceledJobs) {
                return cancelOnFirstFailure;
            }
        };
    }
}

