/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class JarFileHelper {
    private JarFileHelper() {
        throw new IllegalCreationException();
    }

    public static JarEntry searchForEntry(JarFile jarFile, String searchTermRegex) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().matches(searchTermRegex)) continue;
            return jarEntry;
        }
        return null;
    }

    public static ZipEntry searchForEntry(ZipFile jarFile, String searchTermRegex) {
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().matches(searchTermRegex)) continue;
            return jarEntry;
        }
        return null;
    }

    public static ZipEntry searchForEntry(ZipFile jarFile, List<String> searchTermRegexes) {
        Enumeration<? extends ZipEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            for (String regex : searchTermRegexes) {
                if (!name.matches(regex)) continue;
                return jarEntry;
            }
        }
        return null;
    }
}

