/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.osgi.framework.Version;

public class InstallationInformation {
    public static String getFullStudioVersion() {
        return InstallationInformation.getPluginVersion().toString();
    }

    public static String getStudioVersion() {
        Version pluginVersion = InstallationInformation.getPluginVersion();
        return pluginVersion.getMajor() + "." + pluginVersion.getMinor() + "." + pluginVersion.getMicro();
    }

    private static Version getPluginVersion() {
        return Platform.getBundle((String)"org.mule.tooling.core").getVersion();
    }

    public static String getJavaVersion() {
        return System.getProperty("java.vendor") + "-" + System.getProperty("java.version");
    }

    public static String getOSString() {
        return System.getProperty("os.name") + "-" + System.getProperty("os.version") + "-" + System.getProperty("os.arch");
    }

    public static String getLastRuntimeVersion() {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        return InstallationInformation.getRuntimeVersion(muleProject);
    }

    public static String getRuntimeVersion(IMuleProject muleProject) {
        List<IServerDefinition> serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        if (!serverDefinitions.isEmpty() && muleProject != null) {
            return muleProject.getRuntimeId();
        }
        return "";
    }
}

