/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.utils.ClasspathEntryUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;

public class ExternalMuleUserLibraryClasspathContainer
extends MuleUserLibraryClasspathContainer {
    private ExternalContributionMuleModule extModule;
    private final IClasspathEntry[] allEntries;

    public ExternalMuleUserLibraryClasspathContainer(String id) {
        super(id);
        this.allEntries = ClasspathEntryUtils.NO_ENTRIES;
    }

    public ExternalMuleUserLibraryClasspathContainer(ExternalContributionMuleModule extModule) {
        super(extModule.getId());
        this.extModule = extModule;
        this.allEntries = this.calculateEntries(Collections.emptyList());
    }

    public ExternalMuleUserLibraryClasspathContainer(ExternalContributionMuleModule extModule, List<IClasspathEntry> additionalEntries) {
        super(extModule.getId());
        this.extModule = extModule;
        this.allEntries = this.calculateEntries(additionalEntries);
    }

    private IClasspathEntry[] calculateEntries(List<IClasspathEntry> addiationalEntries) {
        IClasspathEntry[] allEntries = null;
        try {
            IClasspathEntry extJar = CoreUtils.getExternalContributionsLibAsClasspath(this.extModule);
            IClasspathEntry[] extDeps = CoreUtils.getExternalContributionLibDependenciesAsClasspath(this.extModule);
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(Arrays.asList(extDeps));
            if (extJar != null) {
                entries.add(0, extJar);
            }
            entries.addAll(addiationalEntries);
            allEntries = entries.toArray(new IClasspathEntry[entries.size()]);
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Could not expand contributions dependencies.", e);
            allEntries = new IClasspathEntry[]{};
        }
        return allEntries;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        return this.allEntries;
    }

    @Override
    public String getDescription() {
        if (this.extModule == null) {
            return super.getDescription();
        }
        String schemaVersion = this.extModule.getVersion();
        String contributionVersion = this.extModule.getContributionVersion();
        String version = null;
        if (!StringUtils.isEmpty((String)contributionVersion)) {
            version = contributionVersion;
        } else if (!StringUtils.isEmpty((String)schemaVersion)) {
            version = schemaVersion;
        }
        if (!StringUtils.isEmpty((String)version)) {
            return this.extModule.getName() + " [v" + version + "]";
        }
        return this.extModule.getName();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.allEntries);
        result = 31 * result + (this.extModule == null ? 0 : this.extModule.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalMuleUserLibraryClasspathContainer other = (ExternalMuleUserLibraryClasspathContainer)obj;
        if (!Arrays.equals(this.allEntries, other.allEntries)) {
            return false;
        }
        return !(this.extModule == null ? other.extModule != null : !this.extModule.equals(other.extModule));
    }
}

