/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ExpressionUtils {
    public static final String EMPTY_EXPRESSION = "#[]";
    private static final String PROPERTY_PLACEHOLDER_REGEX = "\\$\\{(.+)\\}";
    private static final Pattern PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.+)\\}");
    private static final String EXPRESSION_REGEX = "\\#\\[((.|\\n|\\r)+)\\]";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\#\\[((.|\\n|\\r)+)\\]");

    private ExpressionUtils() {
    }

    public static boolean isExpressionOrProperty(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && (ExpressionUtils.isExpression(value) || ExpressionUtils.isPropertyPlaceholder(value));
    }

    public static boolean isPropertyPlaceholder(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && PROPERTY_PLACEHOLDER_PATTERN.matcher(value).matches();
    }

    public static boolean isExpression(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && EXPRESSION_PATTERN.matcher(value).matches();
    }

    public static String getExpressionValue(String fullExpression) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(fullExpression);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public static boolean hasPropertyPlaceholder(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && PROPERTY_PLACEHOLDER_PATTERN.matcher(value).find();
    }
}

