/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.util.Stack;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.mule.tooling.core.MuleCorePlugin;

public final class EclipseContextHelper {
    public static final String STUDIO_ROOT_CONTEXT = "org.mule.tooling.core.context";
    private final IEclipseContext context;
    private final Stack<Runnable> restoreActions;

    public static IEclipseContext getStudioContext() {
        return MuleCorePlugin.getStudioContext();
    }

    public static <T> T getFromStudioContext(Class<T> classToGet) {
        return (T)EclipseContextHelper.getStudioContext().get(classToGet);
    }

    public static <T> T createFromStudioContext(Class<T> type) {
        return (T)ContextInjectionFactory.make(type, (IEclipseContext)EclipseContextHelper.getStudioContext());
    }

    public static <T> void configureInstanceInStudioContext(Class<T> type, T instance) {
        EclipseContextHelper.getStudioContext().set(type, instance);
    }

    public static <T> void removeInstanceFromStudioContext(Class<T> type) {
        EclipseContextHelper.getStudioContext().remove(type);
    }

    public static EclipseContextHelper createHelper(IEclipseContext context) {
        return new EclipseContextHelper(context);
    }

    private EclipseContextHelper(IEclipseContext context) {
        this.context = context;
        this.restoreActions = new Stack();
    }

    public <T> T create(Class<T> type) {
        return (T)ContextInjectionFactory.make(type, (IEclipseContext)this.context);
    }

    public <T> void configureInstance(Class<T> type, T instance) {
        Object previous = this.context.get(type);
        this.restoreActions.push(() -> {
            if (previous != null) {
                this.context.set(type, previous);
            } else {
                this.context.remove(type);
            }
        });
        this.context.set(type, instance);
    }

    public void restoreContext() {
        while (!this.restoreActions.isEmpty()) {
            this.restoreActions.pop().run();
        }
    }
}

