/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.CustomCategory;
import org.mule.tooling.core.ICategory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.auth.LoginManager;
import org.mule.tooling.core.auth.LoginManagerFactory;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.deployer.DeploymentStrategy;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.io.ProjectStructureContribution;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.mel.partitioner.MELDocumentPartitioner;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.utils.ClasspathEntryUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.MuleProjectResourceVisitor;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.model.project.ObjectFactory;
import org.mule.tooling.osgi.services.installation.InstallationInformationProviderService;
import org.mule.tooling.utils.SilentRunner;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class CoreUtils {
    private static final String JAVA = "java";
    private static final String RESOURCES = "resources";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String TOOLING_PERSPECTIVE = "org.mule.tooling.ui.toolingPerspective";
    private static final String CONTRIBUTION_DEPENDENCIES_LIBS = "__contributionDependenciesLibs__";
    private static final String EMPTY_MULE_CONFIG_FILE = "emptyMuleConfig.xml";
    private static final String EMPTY_DOMAIN_CONFIG_FILE = "emptyDomainConfig.xml";
    private static final String EMPTY_DOMAIN_EE_CONFIG_FILE = "emptyDomainConfigEnterprise.xml";
    private static final PathMatcher JAR_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.jar");
    private static final PathMatcher ZIP_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.zip");
    private static final PathMatcher POM_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:*.pom");
    private static InstallationInformationProviderService cachedInstallationService = null;
    private static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("([A-Za-z0-9_\\-.]+)-([0-9]+.*)\\.(zip|jar)|([A-Za-z0-9_\\-.]+)\\.(zip|jar)");
    public static final String XML_VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static final String ASYNC_API_DEPENDENCY_SUPPORTED_RUNTIME = "4.6.0";

    private CoreUtils() {
    }

    public static IMuleProject getMuleProjectForSelection(IStructuredSelection selection) throws CoreException {
        Object selected = selection.getFirstElement();
        if (selected != null) {
            IProject selectedProject = null;
            if (selected instanceof IJavaElement) {
                selectedProject = ((IJavaElement)selected).getJavaProject().getProject();
            } else if (selected instanceof IResource) {
                selectedProject = ((IResource)selected).getProject();
            }
            if (selectedProject != null && selectedProject.isAccessible()) {
                return MuleRuntime.create(selectedProject);
            }
        }
        return null;
    }

    public static List<String> getExternalContributionsLibsWithDependenciesAsString(ExternalContributionMuleModule extModule) throws IOException {
        ArrayList<String> libsString = new ArrayList<String>();
        IClasspathEntry contributionLib = CoreUtils.getExternalContributionsLibAsClasspath(extModule);
        if (contributionLib != null) {
            libsString.add(contributionLib.getPath().toString().replace("/", File.separator));
        }
        IClasspathEntry[] iClasspathEntryArray = CoreUtils.getExternalContributionLibDependenciesAsClasspath(extModule);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            libsString.add(entry.getPath().toString().replace("/", File.separator));
            ++n2;
        }
        return libsString;
    }

    public static List<ExternalContributionMuleModule> getExternalContributionModulesInProject(IMuleProject muleProject) {
        return muleProject.getModuleManager().getExternalModules();
    }

    public static IClasspathEntry getExternalContributionsLibAsClasspath(ExternalContributionMuleModule extModule) throws IOException {
        File extensionZipFile;
        IClasspathEntry classpathEntry = null;
        if (extModule != null && extModule.getRoot().exists() && (extensionZipFile = extModule.getExtensionZipFile()) != null) {
            classpathEntry = ClasspathEntryUtils.newLibraryEntryWithNoSourceAttachment((IPath)new Path(extensionZipFile.getAbsolutePath()));
        }
        return classpathEntry;
    }

    public static boolean isExternalContribution(IMessageFlowNode flowNode, IServerDefinition serverDefinition) {
        return !CoreUtils.getExternalContributionsFrom(flowNode, serverDefinition).isEmpty();
    }

    public static List<ExternalContributionMuleModule> getExternalContributionsFrom(IMessageFlowNode flowNode, IServerDefinition serverDefinition) {
        return CoreUtils.getExternalContributionsFrom(flowNode, MuleCorePlugin.getModuleContributionManager(), serverDefinition);
    }

    public static List<ExternalContributionMuleModule> getExternalContributionsFrom(IMessageFlowNode node, IModuleContributionManager moduleContributionManager, IServerDefinition serverDefinition) {
        String type = node.getType();
        return CoreUtils.getExternalContributionsFrom(type, moduleContributionManager, serverDefinition);
    }

    protected static List<ExternalContributionMuleModule> getExternalContributionsFrom(String type, IModuleContributionManager moduleContributionManager, IServerDefinition serverDefinition) {
        List<ExternalContributionMuleModule> externalModules = moduleContributionManager.getExternalModules(serverDefinition);
        return CoreUtils.getModulesContainingType(type, externalModules);
    }

    public static List<ExternalContributionMuleModule> getModulesContainingType(String type, List<ExternalContributionMuleModule> externalModules) {
        ArrayList<ExternalContributionMuleModule> modules = new ArrayList<ExternalContributionMuleModule>();
        for (ExternalContributionMuleModule externalContributionMuleModule : externalModules) {
            Object contributionNamespace = externalContributionMuleModule.getContributionNamespace();
            if (!((String)contributionNamespace).endsWith("/")) {
                contributionNamespace = (String)contributionNamespace + "/";
            }
            if (!type.startsWith((String)contributionNamespace)) continue;
            modules.add(externalContributionMuleModule);
        }
        return modules;
    }

    public static String toClasspathResource(String fileName) {
        return fileName.startsWith(CLASSPATH_PREFIX) ? fileName : CLASSPATH_PREFIX + fileName;
    }

    @Deprecated
    public static IClasspathEntry createClassPathEntryFromURL(URL url) throws IOException {
        return ClasspathEntryUtils.createClassPathEntryFromURL(url);
    }

    public static void refreshProject(String projectName, IProgressMonitor monitor) throws CoreException {
        CoreUtils.refreshProject(projectName, monitor, 2);
    }

    public static void refreshProject(IMuleProject muleProject, IProgressMonitor monitor) throws CoreException {
        CoreUtils.refreshProject(muleProject, monitor, 2);
    }

    public static void silentRefreshProject(IMuleProject muleProject, IProgressMonitor monitor) {
        SilentRunner.run(() -> CoreUtils.refreshProject(muleProject, monitor, 2));
    }

    public static void refreshProject(IMuleProject muleProject, IProgressMonitor monitor, int depth) throws CoreException {
        IProject project = muleProject.getProject();
        if (project != null) {
            project.refreshLocal(depth, monitor);
        }
    }

    public static void refreshProject(String projectName, IProgressMonitor monitor, int depth) throws CoreException {
        IProject project = CoreUtils.getWorkspaceRoot().getProject(projectName);
        if (project != null) {
            project.refreshLocal(depth, monitor);
        }
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static File unzipFileToTemp(File zipFile) throws IOException {
        File destTempDir = StudioFileUtils.calculateTempPath();
        java.nio.file.Path basePath = destTempDir.getAbsoluteFile().toPath().normalize();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zip = new ZipFile(zipFile, 1);){
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            if (!destTempDir.exists()) {
                destTempDir.mkdirs();
            }
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String zipEntryName = zipEntry.getName();
                File file = new File(String.valueOf(destTempDir) + File.separator + zipEntryName);
                java.nio.file.Path entryPath = file.getAbsoluteFile().toPath().normalize();
                if (!entryPath.startsWith(basePath)) {
                    throw new SecurityException("Attempted to write content at illegal location: " + String.valueOf(entryPath.toAbsolutePath()));
                }
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                FileUtils.copyInputStreamToFile((InputStream)zip.getInputStream(zipEntry), (File)file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return destTempDir;
    }

    public static boolean hasExpectedProjectStructure(File rootFile) {
        File muleSourcesDir = new File(new File(rootFile, "META-INF"), "mule-src");
        return muleSourcesDir.exists() && muleSourcesDir.isDirectory();
    }

    public static boolean hasStudioWorkspaceProjectStructure(File rootFile) {
        File pomFile = new File(rootFile, "pom.xml");
        if (pomFile.exists()) {
            return true;
        }
        File muleProject = new File(rootFile, "mule-project.xml");
        return muleProject.exists();
    }

    public static List<File> listFiles(IFolder projectFolder, String extension) throws CoreException {
        ArrayList<File> listed = new ArrayList<File>();
        IResource[] members = projectFolder.members();
        if (!StringUtils.isEmpty((String)extension) && StringUtils.isAlphanumeric((String)extension)) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                File source;
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1 && (source = resource.getLocation().toFile()).getName().endsWith("." + extension)) {
                    listed.add(source);
                }
                ++n2;
            }
        }
        return listed;
    }

    public static List<MuleConfiguration> collectDeployableMuleConfigurationsFromProjectExcluding(final IMuleProject muleProject, final IFile excludingConfigFile, final boolean excludeTestResources) throws CoreException {
        final ArrayList xmlConfigurationFiles = new ArrayList();
        muleProject.getProject().accept((IResourceVisitor)new MuleProjectResourceVisitor(){

            @Override
            public void visitFile(IFile resource) {
                boolean isTestResource;
                boolean bl = isTestResource = excludeTestResources && this.isTestResource(muleProject, resource);
                if (!(isTestResource || excludingConfigFile != null && excludingConfigFile.equals((Object)resource))) {
                    xmlConfigurationFiles.add(resource);
                }
            }

            private boolean isTestResource(IMuleProject muleProject2, IFile resource) {
                if (MuleProjectKind.APPLICATION.classifies(muleProject2)) {
                    return MuleProjectKind.APPLICATION.adapt(muleProject2).isTestResource((IResource)resource);
                }
                return false;
            }
        });
        ArrayList<MuleConfiguration> validMuleConfigurations = new ArrayList<MuleConfiguration>();
        IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
        for (IFile validConfigFile : xmlConfigurationFiles) {
            MuleConfiguration configuration = configurationsCache.getConfiguration(validConfigFile);
            if (configuration == null) continue;
            validMuleConfigurations.add(configuration);
        }
        validMuleConfigurations.addAll(configurationsCache.getExternalConfigurations());
        return validMuleConfigurations;
    }

    public static List<MuleConfiguration> collectMuleConfigurationsImportedInConfig(IMuleProject muleProject, MuleConfiguration muleConfiguration) {
        ArrayList<MuleConfiguration> validMuleConfigurations = new ArrayList<MuleConfiguration>();
        Set<String> xmlConfigurationFilesNames = CoreUtils.getImportsFromConfiguration(muleConfiguration);
        for (String configFileName : xmlConfigurationFilesNames) {
            MuleConfiguration importedConfiguration = CoreUtils.getConfigurationImportedBySpring(muleProject, muleConfiguration, configFileName);
            if (importedConfiguration == null || validMuleConfigurations.contains(importedConfiguration)) continue;
            validMuleConfigurations.add(importedConfiguration);
            validMuleConfigurations.addAll(CoreUtils.collectMuleConfigurationsImportedInConfig(muleProject, importedConfiguration));
        }
        return validMuleConfigurations;
    }

    public static Set<String> getImportsFromConfiguration(MuleConfiguration muleConfiguration) {
        HashSet<String> xmlConfigurationFilesNames = new HashSet<String>();
        for (IMessageFlowEntity entry : muleConfiguration.getGlobalEntries()) {
            if (!(entry instanceof GlobalElement)) continue;
            GlobalElement globalElement = (GlobalElement)entry;
            CoreUtils.addIfMuleImport(muleConfiguration, globalElement, xmlConfigurationFilesNames);
            CoreUtils.addIfSpringImport(muleConfiguration, globalElement, xmlConfigurationFilesNames);
        }
        return xmlConfigurationFilesNames;
    }

    private static void addIfSpringImport(MuleConfiguration muleConfiguration, GlobalElement globalElement, Set<String> xmlConfigurationFilesNames) {
        IReadOnlyProperty importResource;
        if ("http://www.springframework.org/schema/beans/import".equals(globalElement.getType()) && (importResource = (IReadOnlyProperty)globalElement.getProperties().getProperty("resource")) != null && StringUtils.isNotBlank((String)importResource.getValue())) {
            String importResourceStr = importResource.getValue();
            if (importResourceStr.startsWith(CLASSPATH_PREFIX)) {
                importResourceStr = importResourceStr.substring(10);
            }
            xmlConfigurationFilesNames.add(importResourceStr);
        }
    }

    private static void addIfMuleImport(MuleConfiguration muleConfiguration, GlobalElement globalElement, Set<String> xmlConfigurationFilesNames) {
        IReadOnlyProperty importResource;
        if ("http://www.mulesoft.org/schema/mule/core/import".equals(globalElement.getType()) && (importResource = (IReadOnlyProperty)globalElement.getProperties().getProperty("file")) != null && StringUtils.isNotBlank((String)importResource.getValue())) {
            String importResourceStr = importResource.getValue();
            xmlConfigurationFilesNames.add(importResourceStr);
        }
    }

    public static MuleConfiguration getConfigurationImportedBySpring(IMuleProject muleProject, MuleConfiguration muleConfiguration, String springImport) {
        MuleConfiguration importedConfiguration;
        block9: {
            importedConfiguration = null;
            try {
                String configFileTestFullPath = muleProject.getProject().getFolder("src/test/munit").getFullPath().append(springImport).toString();
                String configFileTestResourceFullPath = muleProject.getProject().getFolder("src/test/resources").getFullPath().append(springImport).toString();
                String configFileAppFullPath = muleProject.getMuleAppsFolder().getFullPath().append(springImport).toString();
                String configFileAppResourceFullPath = muleProject.getMuleResourcesFolder().getFullPath().append(springImport).toString();
                IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
                if (muleConfiguration.getScope().equals("munit")) {
                    for (IFile fileConfiguration : configurationsCache.getConfigurationResources()) {
                        if (configFileTestFullPath.equals(fileConfiguration.getFullPath().toString())) {
                            importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                            break;
                        }
                        if (!configFileTestResourceFullPath.equals(fileConfiguration.getFullPath().toString())) continue;
                        importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                    }
                    if (importedConfiguration != null) break block9;
                    for (IFile fileConfiguration : configurationsCache.getConfigurationResources()) {
                        if (configFileAppFullPath.equals(fileConfiguration.getFullPath().toString())) {
                            importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                            break block9;
                        }
                        if (!configFileAppResourceFullPath.equals(fileConfiguration.getFullPath().toString())) continue;
                        importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                    }
                    break block9;
                }
                for (IFile fileConfiguration : configurationsCache.getConfigurationResources()) {
                    if (configFileAppFullPath.equals(fileConfiguration.getFullPath().toString())) {
                        importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                        break;
                    }
                    if (!configFileAppResourceFullPath.equals(fileConfiguration.getFullPath().toString())) continue;
                    importedConfiguration = configurationsCache.getConfiguration(fileConfiguration);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while retrieving configurations resources from cache", e);
            }
        }
        return importedConfiguration;
    }

    public static File getProjectRootFile(IMuleProject muleProject) {
        URI projectLocationURI = muleProject.getProject().getLocationURI();
        return new File(projectLocationURI);
    }

    public static String getDefaultServerRuntimeId() {
        IServerDefinition serverDefinition = CoreUtils.getDefaultServer();
        return serverDefinition != null ? serverDefinition.getId() : null;
    }

    public static IServerDefinition getDefaultServer() {
        List<IServerDefinition> serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        IServerDefinition serverDefinition = null;
        if (serverDefinitions == null || serverDefinitions.isEmpty()) {
            throw new IllegalStateException("There are no Mule Servers installed. Anypoint Studio requires at least one server runtime in order to work properly.");
        }
        serverDefinition = serverDefinitions.get(serverDefinitions.size() - 1);
        return serverDefinition;
    }

    public static boolean isServerAvailable(String runtimeId) {
        return MuleCorePlugin.getServerManager().getServerDefinition(runtimeId) != null;
    }

    public static String getActualRuntimeId(IMuleProject muleProject) {
        String actualRuntimeId;
        String requestedRuntimeId = muleProject.getRuntimeId();
        if (CoreUtils.isServerAvailable(requestedRuntimeId)) {
            actualRuntimeId = requestedRuntimeId;
        } else {
            actualRuntimeId = CoreUtils.getDefaultServerRuntimeId();
            MuleCorePlugin.logWarning("Server version: " + requestedRuntimeId + " not found. Default Server version " + actualRuntimeId + " used.", null);
        }
        return actualRuntimeId;
    }

    public static IServerDefinition getServerDefinition(IFlowTransformerContext context) {
        return context.getMuleProject().getServerDefinition();
    }

    public static String[] getServerClasspathElements(IServerDefinition server) {
        List<ClasspathElementDefinition> libraryFolders = server.getClasspathElements();
        String[] libraryPaths = new String[libraryFolders.size()];
        int i = 0;
        while (i < libraryFolders.size()) {
            libraryPaths[i] = libraryFolders.get(i).getAbsolutePath().replace("/", File.separator);
            ++i;
        }
        return libraryPaths;
    }

    public static String[] getServerLibraryPathsForClasspath(IServerDefinition server) {
        List<LibraryFolderDefinition> libraryFolders = server.getLibraryFolders();
        ArrayList<String> libraryPaths = new ArrayList<String>();
        String toolingSupportPath = server.getPluginBaseDirectory().append("/mule/tooling/").toOSString();
        libraryPaths.add(toolingSupportPath);
        for (LibraryFolderDefinition libraryFolder : libraryFolders) {
            if (!libraryFolder.isIncludeInContainer()) continue;
            libraryPaths.add(libraryFolder.getAbsolutePath().replace("/", File.separator));
        }
        return libraryPaths.toArray(new String[libraryPaths.size()]);
    }

    public static IClasspathEntry[] getExternalContributionLibDependenciesAsClasspath(ExternalContributionMuleModule extModule) throws IOException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        File contributionLibs = extModule.getLibs();
        if (contributionLibs == null) {
            return new IClasspathEntry[0];
        }
        java.nio.file.Path path = Paths.get(contributionLibs.toURI());
        JarCollector collector = new JarCollector();
        Files.walkFileTree(path, collector);
        for (java.nio.file.Path jarPath : collector.jars) {
            IClasspathEntry entry = CoreUtils.createClassPathEntryFromURL(jarPath.toUri().toURL());
            if (entry == null) continue;
            result.add(entry);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    public static boolean isMuleExternalContributionDependencyLib(IPath path) {
        return path.toOSString().contains(CONTRIBUTION_DEPENDENCIES_LIBS);
    }

    public static List<ExternalContributionMuleModule> getExternalModulesFromContainerIPath(IPath containerPath, IMuleProject muleProject) {
        List<ExternalContributionMuleModule> availableModules = muleProject.getModuleManager().getExternalModules();
        ArrayList<ExternalContributionMuleModule> matchingModules = new ArrayList<ExternalContributionMuleModule>();
        String extensionCoordinates = MuleUserLibraryClasspathContainer.getCoordinatesFromPath(containerPath);
        for (ExternalContributionMuleModule externalContributionMuleModule : availableModules) {
            if (!externalContributionMuleModule.getId().equalsIgnoreCase(extensionCoordinates)) continue;
            matchingModules.add(externalContributionMuleModule);
        }
        return matchingModules;
    }

    public static boolean isMuleExtensionContainer(IPath path) {
        return path != null && path.segmentCount() > 1 && path.segment(0).equals("MULE_LIB");
    }

    public static boolean isExceptionStrategy(IMessageFlowNode node) {
        return node.getType().contains("on-error");
    }

    public static boolean isGlobal(IMessageFlowNode node) {
        return CoreUtils.getAnyDefinition(node) instanceof GlobalDefinition;
    }

    public static boolean isCloudConnector(IMessageFlowNode node, IServerDefinition serverDefinition) {
        NodeDefinition template = CoreUtils.getAnyDefinition(node);
        return CoreUtils.getCategory(node) == Category.CLOUD_CONNECTORS && (template instanceof EndpointDefinition && !CoreUtils.getExternalContributionsFrom(node, MuleCorePlugin.getModuleContributionManager(), serverDefinition).isEmpty() || template instanceof PatternDefinition);
    }

    public static ICategory getCategory(IMessageFlowNode node) {
        NodeDefinition template = CoreUtils.getAnyDefinition(node);
        ICategory category = Category.asCategory(template.getCategoryId());
        if (category == null) {
            category = new CustomCategory(template.getCategoryId());
        }
        return category;
    }

    public static NodeDefinition getAnyDefinition(IMessageFlowNode node) {
        NodeDefinition template = node.getDefinition();
        if (template == null && (template = MuleCorePlugin.getModuleManager().getDefinition(node.getType(), false)) == null) {
            template = MuleCorePlugin.getModuleManager().getGlobalDefinition(node.getType());
        }
        return template;
    }

    public static <T> List<T> getExtensionPointObjects(String extensionPointId, Class<T> type) {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        ArrayList<T> extensionObjects = new ArrayList<T>(configurationElements.length);
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object element = configurationElement.createExecutableExtension("class");
                if (type.isInstance(element)) {
                    T extensionObject = type.cast(element);
                    extensionObjects.add(extensionObject);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while retrieving extension point objects from " + extensionPointId, e);
            }
            ++n2;
        }
        return extensionObjects;
    }

    public static void prepareMuleDomainProjectFolders(IProject project) throws CoreException {
        File projectFolder = project.getLocation().toFile();
        CoreUtils.prepareMuleDomainProjectFolders(projectFolder);
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void prepareMuleDomainProjectFolders(File projectFolder) {
        File srcFolder = new File(projectFolder, "src/");
        CoreUtils.createIfNotExists(srcFolder);
        CoreUtils.createIfNotExists(new File(projectFolder, "target"));
        File mainFolder = new File(srcFolder, "main");
        CoreUtils.createIfNotExists(mainFolder);
        CoreUtils.createIfNotExists(new File(mainFolder, "mule"));
        CoreUtils.createIfNotExists(new File(mainFolder, JAVA));
        CoreUtils.createIfNotExists(new File(mainFolder, RESOURCES));
    }

    public static void prepareMuleProjectFolders(IProject project) throws CoreException {
        File projectFolder = project.getLocation().toFile();
        CoreUtils.prepareMuleProjectFolders(projectFolder);
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void prepareMuleProjectFolders(File projectFolder) {
        File srcFolder = new File(projectFolder, "src/");
        CoreUtils.createIfNotExists(srcFolder);
        CoreUtils.createIfNotExists(new File(projectFolder, "target"));
        File mainFolder = new File(srcFolder, "main");
        CoreUtils.createIfNotExists(mainFolder);
        CoreUtils.createIfNotExists(new File(mainFolder, JAVA));
        CoreUtils.createIfNotExists(new File(mainFolder, RESOURCES));
        CoreUtils.createIfNotExists(new File(mainFolder, "mule"));
        File testFolder = new File(srcFolder, "test");
        CoreUtils.createIfNotExists(testFolder);
        CoreUtils.createIfNotExists(new File(testFolder, JAVA));
        CoreUtils.createIfNotExists(new File(testFolder, RESOURCES));
        for (ProjectStructureContribution contribution : ProjectStructureContributionManager.getDefault().getContributions()) {
            CoreUtils.createIfNotExists(new File(projectFolder, contribution.getFolderPath()));
        }
    }

    public static void createDocumentationStructure(IMuleProject project) throws CoreException {
        String rootPath = project.getLocation().toOSString();
        File docsFolder = new File(rootPath, "exchange-docs");
        CoreUtils.createIfNotExists(docsFolder);
        CoreUtils.createHomeMDIfNotExists(docsFolder);
        project.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void createHomeMDIfNotExists(File docsFolder) throws CoreException {
        try {
            new File(docsFolder, "home.md").createNewFile();
        }
        catch (IOException e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Error creating documentation files", e));
        }
    }

    private static void createIfNotExists(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static File getWorkspaceLocation() {
        return CoreUtils.getWorkspaceRoot().getRawLocation().toFile();
    }

    public static IFile getResourceFromFile(File file) {
        return CoreUtils.getWorkspaceRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
    }

    public static IPath getPathForClasspathEntry(IClasspathEntry entry, IJavaProject javaProject) throws JavaModelException {
        IPath entryFile = null;
        if (entry.getEntryKind() == 4) {
            entryFile = CoreUtils.getPathForVariableClasspathEntry(entry);
        } else if (entry.getEntryKind() == 1) {
            entryFile = CoreUtils.getPathForLibraryClasspathEntry(entry, javaProject);
        }
        return entryFile;
    }

    public static IPath getPathForLibraryClasspathEntry(IClasspathEntry entry, IJavaProject javaProject) throws JavaModelException {
        IPath entryFile = null;
        IPackageFragmentRoot packageFragmentRoot = javaProject.findPackageFragmentRoot(entry.getPath());
        if (packageFragmentRoot != null) {
            if (packageFragmentRoot.isExternal()) {
                entryFile = entry.getPath();
            } else {
                IProject project = javaProject.getProject();
                if (entry.getPath().matchingFirstSegments(project.getFullPath()) > 0) {
                    IPath entryPathWithinProject = entry.getPath().removeFirstSegments(1);
                    entryFile = project.getLocation().append(entryPathWithinProject);
                } else {
                    entryFile = project.getLocation().removeLastSegments(1).append(entry.getPath());
                }
            }
        }
        return entryFile;
    }

    public static IPath getPathForVariableClasspathEntry(IClasspathEntry entry) {
        return JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry).getPath();
    }

    public static File getFileForClasspathEntry(IClasspathEntry entry, IJavaProject javaProject) throws JavaModelException {
        IPath entryPath = CoreUtils.getPathForClasspathEntry(entry, javaProject);
        return entryPath != null ? entryPath.toFile() : null;
    }

    public static boolean hasNature(IProject project, String natureId) throws CoreException {
        if (project != null && project.exists() && project.isAccessible()) {
            String[] ids;
            IProjectDescription description = project.getDescription();
            String[] stringArray = ids = description.getNatureIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (natureId.equals(id)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public static boolean hasSDKNature(IProject project) throws CoreException {
        return CoreUtils.hasNature(project, "org.mule.tooling.sdk.sdkNature");
    }

    public static boolean hasMuleNature(IProject project) throws CoreException {
        return CoreUtils.hasNature(project, "org.mule.tooling.core.muleStudioNature");
    }

    public static boolean hasMuleDomainNature(IProject project) throws CoreException {
        return CoreUtils.hasNature(project, "org.mule.tooling.core.muleStudioDomainNature");
    }

    public static List<ExternalContributionMuleModule> selectExternalModulesForVersion(String muleVersion, Collection<ExternalContributionMuleModule> modules) {
        ArrayList<ExternalContributionMuleModule> compatibleModules = new ArrayList<ExternalContributionMuleModule>(modules);
        CollectionUtils.filter(compatibleModules, (Predicate)CoreUtils.byMinAndMaxVersionAgainst(muleVersion));
        return compatibleModules;
    }

    private static Predicate byMinAndMaxVersionAgainst(final String muleVersion) {
        return new Predicate(){

            public boolean evaluate(Object object) {
                boolean satisfiesMaximumVersion;
                ExternalContributionMuleModule extModule = (ExternalContributionMuleModule)object;
                if (extModule == null) {
                    return false;
                }
                VersionComparator muleVersionComparator = VersionComparator.forVersion(muleVersion);
                String moduleMinimumVersion = extModule.getMinimumVersion() == null ? "0" : extModule.getMinimumVersion();
                String moduleMaximumVersion = extModule.getMaximumVersion();
                boolean satisfiesMinimumVersion = muleVersionComparator.compareVersionTo(moduleMinimumVersion) >= 0;
                boolean bl = satisfiesMaximumVersion = muleVersionComparator.compareVersionTo(moduleMaximumVersion) < 0;
                return satisfiesMinimumVersion && satisfiesMaximumVersion;
            }
        };
    }

    public static MuleExtension getMuleExtensionFromModule(ExternalContributionMuleModule module) {
        return CoreUtils.getMuleExtensionFromModule(module, false);
    }

    public static MuleExtension getMuleExtensionFromModule(ExternalContributionMuleModule module, boolean isTest) {
        MuleExtension moduleAsExtension = new ObjectFactory().createMuleExtension();
        moduleAsExtension.setName(module.getName());
        moduleAsExtension.setQualifier(module.getId());
        if (isTest) {
            moduleAsExtension.setScope(MavenDependency.Scope.TEST.asString());
        }
        return moduleAsExtension;
    }

    public static List<IClasspathEntry> getNonMuleRuntimeClasspathEntries(IMuleProject muleProject) throws CoreException {
        return CoreUtils.getNonMuleRuntimeClasspathEntries(muleProject, entry -> ProjectClasspathUtils.isUserLibrary(entry));
    }

    public static List<IClasspathEntry> getNonMuleRuntimeClasspathEntries(IMuleProject muleProject, java.util.function.Predicate<IClasspathEntry> classpathContainerFilter) throws CoreException {
        ArrayList<IClasspathEntry> nonMuleRuntimeClasspathEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] allClasspathEntries = muleProject.getJavaProject().getRawClasspath();
            CoreUtils.resolveNonMuleRuntimeClasspathEntries(nonMuleRuntimeClasspathEntries, muleProject, allClasspathEntries, classpathContainerFilter);
        }
        catch (JavaModelException e) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Problem getting the projects classpath", e));
        }
        return nonMuleRuntimeClasspathEntries;
    }

    private static void resolveNonMuleRuntimeClasspathEntries(List<IClasspathEntry> nonMuleRuntimeClasspathEntries, IMuleProject muleProject, IClasspathEntry[] classpathEntries, java.util.function.Predicate<IClasspathEntry> classpathContainerFilter) throws JavaModelException {
        if (classpathEntries != null && classpathEntries.length > 0) {
            IClasspathEntry[] iClasspathEntryArray = classpathEntries;
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathContainer container;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1 || entry.getEntryKind() == 4) {
                    nonMuleRuntimeClasspathEntries.add(entry);
                } else if (entry.getEntryKind() == 5 && classpathContainerFilter.test(entry) && !ProjectClasspathUtils.isSystemUserLibrary(container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)muleProject.getJavaProject()))) {
                    nonMuleRuntimeClasspathEntries.add(entry);
                    if (container != null) {
                        CoreUtils.resolveNonMuleRuntimeClasspathEntries(nonMuleRuntimeClasspathEntries, muleProject, container.getClasspathEntries(), classpathContainerFilter);
                    }
                }
                ++n2;
            }
        }
    }

    public static IFile createEmptyXmlConfiguration(IMuleProject muleProject, String fileName) throws CoreException, IOException {
        String emptyConfig = CoreUtils.getEmptyConfigContents(muleProject);
        return CoreUtils.createXMLConfiguration(muleProject, fileName, emptyConfig);
    }

    public static String getEmptyConfigContents(MuleProjectKind<?> kind, boolean isEnterprise) throws IOException {
        String templateResource = null;
        if (MuleProjectKind.APPLICATION.equals(kind)) {
            templateResource = EMPTY_MULE_CONFIG_FILE;
        } else if (MuleProjectKind.DOMAIN.equals(kind) && isEnterprise) {
            templateResource = EMPTY_DOMAIN_EE_CONFIG_FILE;
        } else if (MuleProjectKind.DOMAIN.equals(kind) && !isEnterprise) {
            templateResource = EMPTY_DOMAIN_CONFIG_FILE;
        }
        String emptyConfig = CoreUtils.inputStreamToString(CoreUtils.class.getClassLoader().getResourceAsStream(templateResource));
        return emptyConfig;
    }

    public static String getEmptyConfigContents(IMuleProject muleProject) throws IOException {
        return CoreUtils.getEmptyConfigContents(muleProject.getKind(), muleProject.getServerDefinition().isEnterpriseRuntime());
    }

    public static IFile createEmptyXmlConfiguration(IMuleProject muleProject) throws CoreException, IOException {
        String name = null;
        if (MuleProjectKind.APPLICATION.classifies(muleProject)) {
            name = MessageFormat.format("{0}.{1}", muleProject.getName(), "xml");
        } else if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            name = MessageFormat.format("{0}.{1}", "mule-domain-config", "xml");
        }
        return CoreUtils.createEmptyXmlConfiguration(muleProject, name);
    }

    public static IFile createXMLConfiguration(IMuleProject muleProject, String fileName, String muleConfig) throws IOException, CoreException {
        return CoreUtils.createXMLConfiguration(muleProject, fileName, muleConfig, muleProject.getMuleAppsFolder());
    }

    public static IFile createXMLConfiguration(IMuleProject muleProject, String fileName, String muleConfig, IFolder outputFolder) throws IOException, CoreException {
        boolean isEnterprise = muleProject.getServerDefinition().isEnterpriseRuntime();
        String version = (isEnterprise ? "EE" : "CE") + "-" + muleProject.getServerDefinition().getVersion();
        String muleConfigContent = StringUtils.replace((String)muleConfig, (String)"${version}", (String)version);
        MuleResourceUtils.createFile(muleProject.getProject(), outputFolder, muleConfigContent, fileName);
        return outputFolder.getFile(fileName);
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        return CoreUtils.inputStreamToString(inputStream, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String inputStreamToString(InputStream inputStream, String encoding) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)inputStream, (String)encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static String inputStreamToString(InputStream inputStream, Charset encoding) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)encoding);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static String getJavaFriendlyProjectName(String appName) {
        String projectName = appName.toLowerCase().trim();
        return projectName.replace(' ', '_');
    }

    public static boolean isMuleError(IMarker problemMarker) throws CoreException {
        Integer severity = (Integer)problemMarker.getAttribute("severity");
        String type = problemMarker.getType();
        return severity != null && severity >= 2 && (type.equals("org.mule.tooling.core.messageFlowError") || type.equals("org.eclipse.jdt.core.problem") || type.equals("org.mule.tooling.core.xmlSyntaxError"));
    }

    public static boolean hasMuleErrors(IMuleProject muleProject) {
        boolean retVal = false;
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = muleProject.getProject().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                if (CoreUtils.isMuleError(iMarker)) {
                    retVal = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Problem retrieving errors from AnypointStudio project...", e);
        }
        return retVal;
    }

    public static List<IResource> getProjectSourceDirectories(final IProject project) {
        final ArrayList<IResource> sourceDirectories = new ArrayList<IResource>();
        SilentRunner.run((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (project.isOpen() && project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                    IClasspathEntry[] iClasspathEntryArray = classpathEntries = classpathEntries.length != 0 ? classpathEntries : javaProject.getRawClasspath();
                    int n = classpathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getContentKind() == 1) {
                            IClasspathEntry resolvedClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                            String relativePath = resolvedClasspathEntry.getPath().toString();
                            IResource resource = CoreUtils.getWorkspaceRoot().findMember(relativePath);
                            if (resource != null) {
                                sourceDirectories.add(resource);
                            }
                        }
                        ++n2;
                    }
                }
                return null;
            }
        }, null);
        return sourceDirectories;
    }

    public static GlobalElement retrieveGlobalElement(MuleConfiguration configuration, IMuleProject muleProject, String configRefName) {
        GlobalElement result = CoreUtils.retrieveGlobalElement(configuration, configRefName);
        if (result == null) {
            result = CoreUtils.retrieveGlobalElement(muleProject, configRefName);
        }
        return result;
    }

    public static GlobalElement retrieveGlobalElement(MuleConfiguration muleConfiguration, String name) {
        GlobalElement returnValue = null;
        if (muleConfiguration != null && name != null) {
            List<IMessageFlowEntity> globals = muleConfiguration.getGlobalEntries();
            for (IMessageFlowEntity global : globals) {
                GlobalElement globalElement;
                String nameProperty;
                IMessageFlowEntity value = global;
                if (!(value instanceof GlobalElement) || (nameProperty = CoreUtils.getNameProperty(globalElement = (GlobalElement)value)) == null || !nameProperty.equals(name)) continue;
                returnValue = globalElement;
                break;
            }
        }
        return returnValue;
    }

    public static String getNameProperty(IMessageFlowNode node) {
        IReadOnlyProperty nameProperty = PropertiesUtils.findPropertyByName(node, "name");
        return nameProperty != null ? nameProperty.getValue() : null;
    }

    public static GlobalElement retrieveGlobalElement(IMuleProject project, String name) {
        GlobalElement returnValue = null;
        List<MuleConfiguration> muleConfigs = project.getConfigurationsCache().getConfigurations();
        if (muleConfigs != null) {
            for (MuleConfiguration config : muleConfigs) {
                returnValue = CoreUtils.retrieveGlobalElement(config, name);
                if (returnValue != null) break;
            }
        }
        return returnValue;
    }

    public static boolean isDeprecated(MessageFlowNode node, IMuleProject muleProject) {
        String projectVersion = muleProject.getServerDefinition().getVersion();
        NodeDefinition definition = node.getDefinition();
        IKnowsVersionRange deprecationService = definition != null ? definition.getService(IKnowsVersionRange.class) : null;
        return deprecationService != null ? deprecationService.isDeprecatedIn(projectVersion) : false;
    }

    public static boolean isDeprecated(VersionRange elementVersion, String muleVersion) {
        if (StringUtils.isNotEmpty((String)muleVersion) && elementVersion != null) {
            int indexOf = muleVersion.indexOf(59);
            if (indexOf != -1) {
                muleVersion = muleVersion.substring(0, indexOf);
            }
            return elementVersion.isIncluded(new Version(muleVersion));
        }
        return false;
    }

    public static String getArtifactIdFromFilename(String filename) {
        Matcher m;
        if (filename != null && (m = ARTIFACT_ID_PATTERN.matcher(filename)).matches()) {
            return m.group(1) != null ? m.group(1) : m.group(4);
        }
        return null;
    }

    public static String getArtifactVersionFromFilename(String filename) {
        Matcher m;
        if (filename != null && (m = ARTIFACT_ID_PATTERN.matcher(filename)).matches()) {
            return m.group(2);
        }
        return null;
    }

    public static <T> List<T> filterByType(Iterable<?> collection, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object object : collection) {
            if (object == null || !clazz.isAssignableFrom(object.getClass())) continue;
            result.add(clazz.cast(object));
        }
        return result;
    }

    public static <T> List<T> filterByType(Object[] array, Class<T> clazz) {
        return CoreUtils.filterByType(Arrays.asList(array), clazz);
    }

    public static IPath getPathFromURL(URL url) throws IOException {
        URL resolvedUrl;
        if (url != null && (resolvedUrl = FileLocator.resolve((URL)url)) != null) {
            String path = CoreUtils.pathDecoder(resolvedUrl.getFile(), "UTF-8");
            return Path.fromOSString((String)CoreUtils.makeAbsolute(path));
        }
        return null;
    }

    public static String makeAbsolute(String path) {
        try {
            URI uri = URIUtil.fromString((String)path);
            if (uri.getScheme() != null) {
                return CoreUtils.makeAbsolute(uri.getSchemeSpecificPart());
            }
            return path;
        }
        catch (URISyntaxException e) {
            MuleCorePlugin.logError("Failed to convert path to absolute.", e);
            return path;
        }
    }

    public static String pathDecoder(String path, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = path.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("pathDecoder: Empty string enc parameter");
        }
        byte[] bytes = null;
        while (i < numChars) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(path.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = path.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("pathDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("pathDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    break;
                }
                default: {
                    sb.append(c);
                    ++i;
                }
            }
        }
        return needToChange ? sb.toString() : path;
    }

    @Deprecated
    public static IClasspathEntry createClassPathEntryWithSourceAttachmentFromURL(URL url, URL sourceUrl) throws IOException {
        return ClasspathEntryUtils.createClassPathEntryWithSourceAttachmentFromURL(url, sourceUrl);
    }

    public static boolean containsWhitespace(String vl) {
        int a = 0;
        while (a < vl.length()) {
            if (Character.isWhitespace(vl.charAt(a))) {
                return true;
            }
            ++a;
        }
        return false;
    }

    public static boolean equalsAny(Object o1, Object ... objects) {
        return Arrays.asList(objects).contains(o1);
    }

    public static boolean equalsNone(Object o1, Object ... objects) {
        return !CoreUtils.equalsAny(o1, objects);
    }

    public static boolean isToolingPerspective() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.core.toolingperspectives");
        ArrayList<String> contributedPerspectiveIds = new ArrayList<String>(configurationElements.length);
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            contributedPerspectiveIds.add(configurationElement.getAttribute("perspectiveId"));
            ++n2;
        }
        String activePerspectiveId = CoreUtils.getActivePerspetiveId();
        return TOOLING_PERSPECTIVE.equals(activePerspectiveId) || contributedPerspectiveIds.contains(activePerspectiveId);
    }

    public static String getActivePerspetiveId() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor perspective = activePage.getPerspective();
        return perspective.getId();
    }

    public static DeploymentStrategy getFirstDeploymentStrategyThatApplies(List<DeploymentStrategy> deploymentStrategies, IMuleProject muleProject) {
        for (DeploymentStrategy deploymentStrategy : deploymentStrategies) {
            if (!deploymentStrategy.appliesTo(muleProject)) continue;
            return deploymentStrategy;
        }
        return null;
    }

    public static DeploymentStrategy getDeploymentStrategy(IMuleProject muleProject) {
        List<DeploymentStrategy> deploymentStrategies = CoreUtils.getExtensionPointObjects("org.mule.tooling.core.deploymentStrategies", DeploymentStrategy.class);
        return CoreUtils.getFirstDeploymentStrategyThatApplies(deploymentStrategies, muleProject);
    }

    public static boolean isValidURL(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
    }

    public static String getPathFromResource(IMuleProject muleProject, String selectedResource) {
        if (muleProject == null || selectedResource == null) {
            return null;
        }
        if (CoreUtils.isScript(selectedResource)) {
            return selectedResource;
        }
        Optional<String> fileFullPathFromSelectedResource = CoreUtils.getFileFullPathFromSelectedResource(selectedResource, muleProject);
        if (fileFullPathFromSelectedResource.isPresent()) {
            return fileFullPathFromSelectedResource.get();
        }
        if (CoreUtils.isValidURL(selectedResource)) {
            return selectedResource;
        }
        return null;
    }

    public static Optional<String> getFileFullPathFromSelectedResource(String selectedResource, IMuleProject muleProject) {
        File file = new File(selectedResource);
        if (file.exists()) {
            return Optional.of(file.getAbsolutePath());
        }
        try {
            IFile iFile = muleProject.getFile(selectedResource);
            if (iFile.exists()) {
                return Optional.of(iFile.getLocation().toOSString());
            }
            IProject project = muleProject.getProject();
            List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
            for (IResource resource : projectSourceDirectories) {
                IFolder srcFolder;
                IFile src;
                if (!(resource instanceof IFolder) || !(src = (srcFolder = (IFolder)resource).getFile(selectedResource)).exists()) continue;
                return Optional.of(src.getLocation().toOSString());
            }
        }
        catch (RuntimeException runtimeException) {}
        return Optional.empty();
    }

    public static Optional<IFile> getResource(String resourceName, IMuleProject muleProject) {
        resourceName = CoreUtils.toFileName(resourceName);
        IProject project = muleProject.getProject();
        List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
        for (IResource sourceFolder : projectSourceDirectories) {
            IFolder srcFolder;
            IFile resource;
            if (!(sourceFolder instanceof IFolder) || !(resource = (srcFolder = (IFolder)sourceFolder).getFile(resourceName)).exists()) continue;
            return Optional.ofNullable(resource);
        }
        return Optional.empty();
    }

    public static Optional<String> toClasspathResource(File file, IMuleProject muleProject) {
        String projectAbsolutePath;
        if (file == null) {
            return Optional.empty();
        }
        File projectRootFile = CoreUtils.getProjectRootFile(muleProject);
        String fileAbsolutePath = file.getAbsolutePath();
        boolean isProjectFile = fileAbsolutePath.startsWith(projectAbsolutePath = projectRootFile.getAbsolutePath());
        if (isProjectFile) {
            Path filePath = new Path(fileAbsolutePath.substring(projectAbsolutePath.length()));
            IProject project = muleProject.getProject();
            List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
            for (IResource sourceFolder : projectSourceDirectories) {
                IPath relativeFilePath;
                IFile resource;
                IFolder localSourcefolder;
                IPath localSourcePath;
                if (!(sourceFolder instanceof IFolder) || !(localSourcePath = (localSourcefolder = (IFolder)sourceFolder).getProjectRelativePath()).isPrefixOf((IPath)filePath) || !(resource = localSourcefolder.getFile(relativeFilePath = filePath.makeRelativeTo(localSourcePath))).exists()) continue;
                return Optional.of(relativeFilePath.toString());
            }
        }
        return Optional.empty();
    }

    public static String toFileName(String resourceName) {
        if (resourceName.startsWith(CLASSPATH_PREFIX)) {
            resourceName = resourceName.substring(CLASSPATH_PREFIX.length());
        }
        return resourceName;
    }

    public static List<IResource> filterResources(IMuleProject muleProject, final IResourceVisitor filter) {
        final ArrayList<IResource> result = new ArrayList<IResource>();
        IProject project = muleProject.getProject();
        try {
            List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
            for (IResource resource : projectSourceDirectories) {
                if (!(resource instanceof IFolder)) continue;
                IFolder srcFolder = (IFolder)resource;
                srcFolder.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (filter.visit(resource)) {
                            result.add(resource);
                        }
                        return true;
                    }
                });
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while filtering resource", e);
        }
        return result;
    }

    public static boolean isScript(String selectedLocation) {
        if (StringUtils.isBlank((String)selectedLocation)) {
            return false;
        }
        MELDocumentPartitioner melDocumentPartitioner = new MELDocumentPartitioner(selectedLocation);
        ITypedRegion[] computePartitioning = melDocumentPartitioner.computePartitioning(0, selectedLocation.length());
        return computePartitioning.length > 1;
    }

    public static String getStudioUniqueId() {
        return UUID.randomUUID().toString();
    }

    public static List<IServerDefinition> getEEServers() {
        List<IServerDefinition> serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        ArrayList<IServerDefinition> eeServers = new ArrayList<IServerDefinition>(serverDefinitions.size());
        for (IServerDefinition serverDefinition : serverDefinitions) {
            if (!serverDefinition.isEnterpriseRuntime()) continue;
            eeServers.add(serverDefinition);
        }
        return eeServers;
    }

    public static List<IServerDefinition> getDomainsCapableServers() {
        List<IServerDefinition> serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        ArrayList<IServerDefinition> domainsCapableServers = new ArrayList<IServerDefinition>(serverDefinitions.size());
        return CoreUtils.filterServers(serverDefinitions, domainsCapableServers, "3.5.0");
    }

    private static List<IServerDefinition> filterServers(List<IServerDefinition> serverDefinitions, List<IServerDefinition> capableServers, String minVersion) {
        for (IServerDefinition serverDefinition : serverDefinitions) {
            int compareVersionTo = serverDefinition.compareVersionTo(minVersion);
            if (compareVersionTo < 0) continue;
            capableServers.add(serverDefinition);
        }
        return capableServers;
    }

    public static IMuleDomainProject getDomainProject(IMuleProject muleProject) throws CoreException {
        IMuleApplicationProject muleApplicationProject;
        IMuleDomain domain;
        if (MuleProjectKind.APPLICATION.classifies(muleProject) && (domain = (muleApplicationProject = MuleProjectKind.APPLICATION.adapt(muleProject)).getDomain()) instanceof IMuleDomainProject) {
            return (IMuleDomainProject)domain;
        }
        return null;
    }

    public static void cleanBuildProject(IMuleProject muleProject) throws CoreException {
        IProject project = muleProject.getProject();
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IResource getSourceFolderContainer(IProject project, String filePath) {
        List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
        for (IResource sourceFolder : projectSourceDirectories) {
            File includedFile = CoreUtils.retrieveResourceFromFolder(sourceFolder, filePath);
            if (includedFile == null) continue;
            return sourceFolder;
        }
        return null;
    }

    public static File retrieveResourceFromFolder(IResource sourceFolder, String filePath) {
        Collection files = FileUtils.listFiles((File)sourceFolder.getLocation().toFile(), null, (boolean)true);
        for (File file : files) {
            if (!file.getAbsolutePath().endsWith(filePath)) continue;
            return file;
        }
        return null;
    }

    public static String generateRelativePath(IProject project, IResource resource) {
        return CoreUtils.generateRelativePath(project, resource.getLocation().toOSString());
    }

    public static String generateRelativePath(IProject project, String path) {
        String relativePath = "";
        IResource sourceFolderContainer = CoreUtils.getSourceFolderContainer(project, path);
        if (sourceFolderContainer != null) {
            relativePath = CoreUtils.generateRelativePath(path, sourceFolderContainer);
            return relativePath;
        }
        IFolder appFolder = project.getFolder("src/main/mule");
        if (appFolder != null && appFolder.exists() && CoreUtils.retrieveResourceFromFolder((IResource)appFolder, path) != null) {
            relativePath = CoreUtils.generateRelativePath(path, (IResource)appFolder);
            return relativePath;
        }
        IFolder mappingsFolder = project.getFolder("mappings");
        if (mappingsFolder != null && mappingsFolder.exists() && CoreUtils.retrieveResourceFromFolder((IResource)mappingsFolder, path) != null) {
            relativePath = CoreUtils.generateRelativePath(path, (IResource)mappingsFolder);
            return relativePath;
        }
        return relativePath;
    }

    private static String generateRelativePath(String resourcePath, IResource sourceFolderContainer) {
        String sourceFolderPath = sourceFolderContainer.getLocation().toOSString();
        return resourcePath.substring(sourceFolderPath.length() + 1);
    }

    public static boolean areNotBlank(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringUtils.isBlank((String)string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Authenticator getCurrentAuthenticator() {
        try {
            return Authenticator.getDefault();
        }
        catch (SecurityException e) {
            MuleCorePlugin.logError("Could not retrieve current authenticator", e);
            return null;
        }
    }

    public static InstallationInformationProviderService getInstallationService(Bundle bundle) {
        if (cachedInstallationService == null) {
            ServiceReference reference = bundle.getBundleContext().getServiceReference(InstallationInformationProviderService.class.getName());
            cachedInstallationService = reference != null ? (InstallationInformationProviderService)bundle.getBundleContext().getService(reference) : InstallationInformationProviderService.DEFAULT;
        }
        return cachedInstallationService;
    }

    public static String readInputStreamContent(InputStream stream) {
        String content = "";
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner s = new Scanner(stream);){
            s.useDelimiter("\\A");
            content = s.hasNext() ? s.next() : "";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }

    public static int lastIndexOfRegex(String str, String regex) {
        int lastIndex = -1;
        Matcher matcher = Pattern.compile(regex).matcher(str);
        while (matcher.find()) {
            lastIndex = matcher.start();
        }
        return lastIndex;
    }

    public static int lastIndexOfRegex(String str, String regex, int fromIndex) {
        return CoreUtils.lastIndexOfRegex(str.substring(0, fromIndex), regex);
    }

    public static boolean belongToSameVisibilityScope(MuleConfiguration aMuleConfig, MuleConfiguration anotherMuleConfig) {
        return aMuleConfig.getScope().equalsIgnoreCase(anotherMuleConfig.getScope());
    }

    public static boolean isRemoteUrl(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            return scheme != null && scheme.startsWith("http") && StringUtils.isNotBlank((String)host);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getGA(MuleModule module) {
        return MavenUtils.getGA(MavenUtils.getPluginDependency(module.getId()));
    }

    public static boolean isInTargetLocation(IMuleProject project, IResource resource) {
        IPath targetLocation = project.getJavaProject().getPath().append("target");
        return targetLocation.isPrefixOf(resource.getFullPath());
    }

    public static void addNaturesToProjectDescription(IProjectDescription description, String ... natureIds) {
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids.length + natureIds.length];
        System.arraycopy(ids, 0, newIds, natureIds.length, ids.length);
        int i = 0;
        while (i < natureIds.length) {
            newIds[i] = natureIds[i];
            ++i;
        }
        description.setNatureIds(newIds);
    }

    public static void addBuilderToDescription(IProjectDescription desc, String builderId) {
        ICommand[] commands = desc.getBuildSpec();
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName(builderId);
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
    }

    public static File getFileInLocalRepo(MavenDependency dependency2) {
        return new File(MavenCore.getM2repoPath() + File.separator + MavenResourceUtils.getRepositoryPath(dependency2, File.separator));
    }

    public static Optional<File> fromClassPathResource(String filePath, IMuleProject muleProject) {
        Optional<File> result = Optional.empty();
        IProject project = muleProject.getProject();
        List<IResource> projectSourceDirectories = CoreUtils.getProjectSourceDirectories(project);
        for (IResource sourceFolder : projectSourceDirectories) {
            IFolder localSourcefolder;
            IFile file;
            if (!(sourceFolder instanceof IFolder) || !(file = (localSourcefolder = (IFolder)sourceFolder).getFile(filePath)).exists()) continue;
            result = Optional.of(file.getRawLocation().toFile());
            break;
        }
        return result;
    }

    public static File pathToFile(String filePath, IMuleProject project) {
        return CoreUtils.pathToFile(filePath, project, true);
    }

    public static File pathToFile(String filePath, IMuleProject project, boolean fail) {
        File file = null;
        ArrayList strategies = Lists.newArrayList((Object[])new PathStrategy[]{new AbsolutePathStrategy(), new RelativePathStrategy(), new SourceDirPathStrategy()});
        for (PathStrategy strategy : strategies) {
            Optional<File> maybeFile = strategy.getFile(filePath, project);
            if (!maybeFile.isPresent()) continue;
            file = maybeFile.get();
            break;
        }
        if (file != null) {
            return file;
        }
        if (fail) {
            throw new IllegalArgumentException("File " + filePath + " does not exist or is not readable");
        }
        return null;
    }

    public static boolean isJarFile(File file) {
        return file != null && file.isFile() && JAR_PATH_MATCHER.matches(file.toPath().getFileName());
    }

    public static boolean isZipFile(File file) {
        return file.isFile() && ZIP_PATH_MATCHER.matches(file.toPath().getFileName());
    }

    public static boolean isPomFile(File file) {
        return file.isFile() && POM_PATH_MATCHER.matches(file.toPath().getFileName());
    }

    public static boolean isExternalContributionDefinedInProjectModel(ExternalContributionMuleModule extension, IMuleProjectModel projectModel) {
        MuleExtension muleExtension = CoreUtils.getMuleExtensionFromModule(extension);
        return projectModel.getMuleExtensions().stream().anyMatch(each -> muleExtension.getQualifier().equals(each.getQualifier()));
    }

    public static LoginManager getLoginManager() {
        return EclipseContextHelper.createFromStudioContext(LoginManagerFactory.class).getLoginManager();
    }

    public static boolean isAPIClassifier(String classifier) {
        return IMuleResources.API_CLASSIFIERS.contains(classifier);
    }

    public static boolean isDwLibraryClassifier(String classifier) {
        return classifier != null && "dw-library".contains(classifier);
    }

    public static boolean isAsyncAPIClassifier(String classifier) {
        return classifier != null && IMuleResources.ASYNC_API_CLASSIFIERS.contains(classifier);
    }

    public static boolean isAnyAPITypeClassifier(String classifier) {
        return classifier != null && CoreUtils.isAPIClassifier(classifier) || CoreUtils.isAsyncAPIClassifier(classifier);
    }

    public static boolean isRuntimeCompatibleWithAsyncAPI(List<MavenDependency> dependencies, IServerDefinition serverDefinition) {
        boolean someDependencyIsAsyncApi = dependencies.stream().map(MavenCoordinates::getClassifier).filter(Optional::isPresent).map(Optional::get).anyMatch(type -> type.equals("evented-api"));
        return someDependencyIsAsyncApi ? serverDefinition.compareVersionTo(ASYNC_API_DEPENDENCY_SUPPORTED_RUNTIME) >= 0 : true;
    }

    public static void updateFieldInMuleArtifactJson(File filePath, String field, Object newValue) throws IOException {
        JSONObject jsonObject;
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileReader fileReader = new FileReader(filePath);){
            jsonObject = new JSONObject(new JSONTokener((Reader)fileReader));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        jsonObject.put(field, newValue);
        throwable = null;
        var5_6 = null;
        try (FileWriter fileWriter = new FileWriter(filePath);){
            fileWriter.write(jsonObject.toString(4));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static Optional<Object> getValueInMuleArtifact(File filePath, String field) {
        if (filePath.exists() && !filePath.isDirectory()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileReader fileReader = new FileReader(filePath);){
                    JSONTokener tokener = new JSONTokener((Reader)fileReader);
                    JSONObject jsonObject = new JSONObject(tokener);
                    if (jsonObject.has(field)) {
                        return Optional.ofNullable(jsonObject.get(field));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError("Error trying to read the mule-artifact.json file.", e);
            }
        }
        return Optional.empty();
    }

    private static class AbsolutePathStrategy
    implements PathStrategy {
        private AbsolutePathStrategy() {
        }

        @Override
        public Optional<File> getFile(String filePath, IMuleProject project) {
            File file = new File(filePath);
            if (file.exists() && file.canRead()) {
                return Optional.of(file);
            }
            return Optional.empty();
        }
    }

    private static class JarCollector
    extends SimpleFileVisitor<java.nio.file.Path> {
        List<java.nio.file.Path> jars = new ArrayList<java.nio.file.Path>();

        private JarCollector() {
        }

        @Override
        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
            if (JAR_PATH_MATCHER.matches(file.getFileName())) {
                this.jars.add(file);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    static interface PathStrategy {
        public Optional<File> getFile(String var1, IMuleProject var2);
    }

    private static class RelativePathStrategy
    implements PathStrategy {
        private RelativePathStrategy() {
        }

        @Override
        public Optional<File> getFile(String filePath, IMuleProject project) {
            File file = new File(project.getLocation().toFile(), filePath);
            if (file.exists() && file.canRead()) {
                return Optional.of(file);
            }
            return Optional.empty();
        }
    }

    private static class SourceDirPathStrategy
    implements PathStrategy {
        private SourceDirPathStrategy() {
        }

        @Override
        public Optional<File> getFile(String filePath, IMuleProject muleProject) {
            Optional<IFile> resource = CoreUtils.getResource(filePath, muleProject);
            return resource.map(res -> res.getRawLocation().toFile());
        }
    }
}

