/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.utils.CoreUtils;

public class ClasspathEntryUtils {
    public static final IClasspathEntry[] NO_ENTRIES = new IClasspathEntry[0];
    private static final IAccessRule[] ALL_FORBIDDEN_RULE_ARRAY = new IAccessRule[]{JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1)};
    private static final IClasspathAttribute[] EMPTY_ATTRIBUTES = new IClasspathAttribute[0];

    private ClasspathEntryUtils() {
        throw new IllegalAccessError("Not intended to be called.");
    }

    public static IClasspathEntry newLibraryEntryWithNoSourceAttachment(IPath path) {
        return JavaCore.newLibraryEntry((IPath)path, null, null);
    }

    public static IClasspathEntry newLibraryEntryWithSourceAttachment(IPath path, IPath sourceAttachment) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachment, null);
    }

    public static IClasspathEntry createClassPathEntryFromURL(URL url) throws IOException {
        IClasspathEntry classpathEntry = null;
        IPath resolvedUrl = CoreUtils.getPathFromURL(url);
        if (resolvedUrl != null) {
            classpathEntry = ClasspathEntryUtils.newLibraryEntryWithNoSourceAttachment(resolvedUrl);
        }
        return classpathEntry;
    }

    public static IClasspathEntry createClassPathEntryWithSourceAttachmentFromURL(URL url, URL sourceUrl) throws IOException {
        IClasspathEntry classpathEntry = null;
        IPath resolvedUrl = CoreUtils.getPathFromURL(url);
        if (resolvedUrl != null) {
            IPath sourceAttachment = sourceUrl != null ? CoreUtils.getPathFromURL(sourceUrl) : null;
            classpathEntry = JavaCore.newLibraryEntry((IPath)resolvedUrl, (IPath)sourceAttachment, null);
        }
        return classpathEntry;
    }

    public static IClasspathEntry newLibraryEntryWithRestrictAccess(IPath path, IPath sourceAttachmentPath) {
        return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, null, (IAccessRule[])ALL_FORBIDDEN_RULE_ARRAY, (IClasspathAttribute[])EMPTY_ATTRIBUTES, (boolean)false);
    }
}

