/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClasspathCollection
extends LinkedHashSet<URL> {
    private static final long serialVersionUID = 1L;
    private static final Pattern VERSION_PATTERN = Pattern.compile("(.*)-([0-9]+\\.[0-9]+\\.?.*)\\.jar");
    private Map<String, JarDefinition> jarsByName = new HashMap<String, JarDefinition>();

    @Override
    public boolean add(URL url) {
        if (this.isJar(url)) {
            JarDefinition newJar = JarDefinition.create(url);
            JarDefinition existingJar = this.jarsByName.get(newJar.getName());
            if (existingJar == null) {
                this.jarsByName.put(newJar.getName(), newJar);
                return super.add(url);
            }
            if (existingJar.isOlderThan(newJar)) {
                this.remove(existingJar.getUrl());
                this.jarsByName.put(newJar.getName(), newJar);
                return super.add(url);
            }
            return false;
        }
        return super.add(url);
    }

    private boolean isJar(URL url) {
        try {
            String name = new File(url.toURI()).getName();
            return name.endsWith(".jar") && VERSION_PATTERN.matcher(name).matches();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.jarsByName.clear();
        super.clear();
    }

    @Override
    public boolean remove(Object url) {
        if (url instanceof URL && this.isJar((URL)url)) {
            JarDefinition jarDefinitionToRemove = JarDefinition.create((URL)url);
            this.jarsByName.remove(jarDefinitionToRemove.getName());
        }
        return super.remove(url);
    }

    private static class JarDefinition {
        private static final String TESTS_QUALIFIER = "tests";
        private String name;
        private String version;
        private URL url;

        private JarDefinition(String name, String version, URL url) {
            this.name = name;
            this.version = version;
            this.url = url;
        }

        public boolean isOlderThan(JarDefinition newJar) {
            return this.version.compareTo(newJar.getVersion()) < 0;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public URL getUrl() {
            return this.url;
        }

        public static JarDefinition create(URL url) {
            try {
                String jarFileName = new File(url.toURI()).getName();
                Matcher versionMatcher = VERSION_PATTERN.matcher(jarFileName);
                if (versionMatcher.matches()) {
                    Object name = versionMatcher.group(1);
                    String version = versionMatcher.group(2);
                    if (version.endsWith(TESTS_QUALIFIER)) {
                        name = (String)name + TESTS_QUALIFIER;
                    }
                    return new JarDefinition((String)name, version, url);
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            return null;
        }
    }
}

