/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.File;
import java.util.Properties;
import java.util.jar.JarFile;

public class BundleManifestReader {
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String IMPLEMENTATION_VENDOR_ID = "Implementation-Vendor-Id";
    private final Properties properties;
    private final String artifactId;

    public BundleManifestReader(JarFile jarFile, Properties properties) {
        this.properties = properties;
        this.artifactId = this.fromJarFile(jarFile);
    }

    public String getBundleVersion() {
        return this.properties.getProperty(BUNDLE_VERSION);
    }

    public String getSymbolicName() {
        return this.properties.getProperty(BUNDLE_SYMBOLIC_NAME).split(";")[0];
    }

    public boolean isSingleton() {
        return Boolean.parseBoolean(this.properties.getProperty(BUNDLE_SYMBOLIC_NAME).split(";")[1]);
    }

    public String getImplementationVersion() {
        return this.properties.getProperty(IMPLEMENTATION_VERSION, "");
    }

    public String getImplementationVendorId() {
        return this.properties.getProperty(IMPLEMENTATION_VENDOR_ID, "");
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    private String fromJarFile(JarFile jarFile) {
        int fileNameStartIndex;
        int versionIndex = jarFile.getName().lastIndexOf(this.getImplementationVersion()) - 1;
        if (versionIndex > (fileNameStartIndex = jarFile.getName().lastIndexOf(File.separator) + 1)) {
            return jarFile.getName().substring(fileNameStartIndex, versionIndex);
        }
        return null;
    }
}

