/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.BundleManifestReader;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;

public class BundleJarFileInspector
implements MavenJarFileInspector {
    private static final Pattern MANIFEST_PATTERN = Pattern.compile("META-INF/MANIFEST.MF");
    private static final Pattern POM_PATTERN = Pattern.compile("META-INF/maven.*/pom.*");
    private final JarFile jarFile;

    public BundleJarFileInspector(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public BundleManifestReader getManifest() throws IOException {
        BundleManifestReader bundleManifestReader;
        Properties properties = new Properties();
        InputStream input = null;
        try {
            JarEntry searchForEntry = this.searchForEntry(MANIFEST_PATTERN, false);
            if (searchForEntry != null) {
                input = this.jarFile.getInputStream(searchForEntry);
                properties.load(input);
            }
            bundleManifestReader = new BundleManifestReader(this.jarFile, properties);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        return bundleManifestReader;
    }

    protected JarEntry searchForEntry(Pattern searchTermRegex) throws IOException {
        return this.searchForEntry(searchTermRegex, true);
    }

    protected JarEntry searchForEntry(Pattern manifestPattern, boolean failIfNotFound) throws IOException {
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!manifestPattern.matcher(jarEntry.getName()).find()) continue;
            return jarEntry;
        }
        if (failIfNotFound) {
            throw new IOException(String.format("The search term %s could not be found", manifestPattern));
        }
        return null;
    }

    public String getGroupId() {
        try {
            JarEntry entry;
            String groupId = this.getManifest().getImplementationVendorId();
            if (groupId.isEmpty() && (entry = this.searchForEntry(POM_PATTERN, false)) != null) {
                String[] path = entry.getName().split("/");
                return path[2];
            }
            return groupId;
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error reading groupId. Jar file: " + String.valueOf(this.jarFile), e);
            return null;
        }
    }

    public String getArtifactId() {
        try {
            return this.getManifest().getArtifactId();
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error reading jar file manifest. Jar file: " + String.valueOf(this.jarFile), e);
            return null;
        }
    }

    public String getVersion() {
        try {
            return this.getManifest().getImplementationVersion();
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error reading jar file manifest. Jar file: " + String.valueOf(this.jarFile), e);
            return null;
        }
    }

    public boolean hasPomFile() {
        return false;
    }

    public InputStream getPomFile() {
        return null;
    }
}

