/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.tooling;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrap;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapFactory;
import org.mule.tooling.core.CorruptedInstallationException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.tooling.ToolingClientExtensionManager;

public class ToolingClientBootstrap {
    private static Map<String, ToolingRuntimeClientBootstrap> bootstraps = new ConcurrentHashMap<String, ToolingRuntimeClientBootstrap>();

    private ToolingClientBootstrap() {
    }

    public static ToolingRuntimeClientBootstrap buildToolingBootstrap(IMuleProject muleProject) {
        IServerDefinition serverDefinition = muleProject.getServerDefinition();
        return ToolingClientBootstrap.buildToolingBootstrap(serverDefinition.getVersionWithSuffix());
    }

    public static ToolingRuntimeClientBootstrap buildToolingBootstrap(String muleVersion) {
        String toolingVersion = ToolingClientExtensionManager.build().getToolingClientVersion();
        return MavenCore.runWithPopulatedLocalRepository(() -> bootstraps.computeIfAbsent(toolingVersion, key -> ToolingClientBootstrap.doBuildToolingBootstrap(muleVersion, toolingVersion)));
    }

    public static void dispose() {
        for (ToolingRuntimeClientBootstrap bootstrap : bootstraps.values()) {
            bootstrap.dispose();
        }
        bootstraps.clear();
    }

    private static ToolingRuntimeClientBootstrap doBuildToolingBootstrap(String muleVersion, String toolingVersion) {
        ToolingRuntimeClientBootstrap clientBootstrap = null;
        try {
            MuleCorePlugin.logInfo(String.format("Mule Version %s, was mapped to Tooling Version %s", muleVersion, toolingVersion));
            long startBootstrap = System.currentTimeMillis();
            MavenConfiguration mavenConfiguration = MavenCore.newLocalRepositoryMavenConfiguration();
            ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder toolingRuntimeConfigBuilder = ToolingRuntimeClientBootstrapConfiguration.builder();
            IPath toolingWorkingDir = ToolingCachePathUtils.getWorkingDir().append(toolingVersion);
            ToolingRuntimeClientBootstrapConfiguration toolingRuntimeConfig = toolingRuntimeConfigBuilder.mavenConfiguration(mavenConfiguration).toolingVersion(toolingVersion).muleVersion(muleVersion).workingFolder(toolingWorkingDir.toFile()).build();
            clientBootstrap = ToolingRuntimeClientBootstrapFactory.newToolingRuntimeClientBootstrap((ToolingRuntimeClientBootstrapConfiguration)toolingRuntimeConfig);
            long endBootstrap = System.currentTimeMillis();
            long bootstrapTimeInMillis = endBootstrap - startBootstrap;
            ToolingClientBootstrap.trackBootstrapLoadingTime(muleVersion, toolingVersion, bootstrapTimeInMillis);
            System.out.println("Bootstrap : " + bootstrapTimeInMillis);
        }
        catch (ToolingException e) {
            if ("org.eclipse.aether.transfer.ArtifactNotFoundException".equals(e.getRootCauseType())) {
                throw new CorruptedInstallationException("Error creating bootstrap for tooling client", e);
            }
            throw new IllegalStateException("Error creating bootstrap for tooling client", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating bootstrap for tooling client", e);
        }
        return clientBootstrap;
    }

    private static void trackBootstrapLoadingTime(String muleVersion, String toolingVersion, long bootstrapTimeInMillis) {
        AnalyticsRecordsFactory.single(Events.TOOLING_CLIENT_BOOTSTRAP_INITIALIZED, "muleVersion", muleVersion, "toolingVersion", toolingVersion, "timeInMillis", String.valueOf(bootstrapTimeInMillis)).track();
    }
}

