/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.tooling;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.osgi.framework.Version;

public class ToolingCachePathUtils {
    private ToolingCachePathUtils() {
    }

    public static IPath getCachePath() {
        return ToolingCachePathUtils.getRootCachePath();
    }

    public static IPath getWorkingDir() {
        return ToolingCachePathUtils.getEditorsCachePath().append("workingDir");
    }

    public static IPath getEditorsCachePath() {
        return ToolingCachePathUtils.getRootCachePath().append(ToolingCachePathUtils.getVersion());
    }

    private static String getVersion() {
        Version pluginVersion = MuleCorePlugin.getContext().getBundle().getVersion();
        Version versionForPath = new Version(pluginVersion.getMajor(), pluginVersion.getMinor(), pluginVersion.getMicro());
        return versionForPath.toString();
    }

    private static IPath getRootCachePath() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".mule").append("plugins-tmp").append("repository");
    }

    public static void clearCaches() {
        ToolingCachePathUtils.deletePathContent(ToolingCachePathUtils.getEditorsCachePath());
        ToolingCachePathUtils.deletePathContent(ToolingCachePathUtils.getCachePath());
    }

    private static void deletePathContent(IPath editorsCachePath) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Stream<Path> fileStream = Files.walk(editorsCachePath.toFile().toPath(), new FileVisitOption[0]);){
                fileStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }
}

