/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.tooling;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;

@ExtensionPoint(extensionPointId="org.mule.tooling.core.toolingCache")
public final class ToolingCacheExtension {
    @Inject
    private Bundle bundle;
    @ExtensionAttribute
    private String path;

    public static List<ToolingCacheExtension> getExtensions() {
        return ToolingCacheExtensionsHolder.extensions;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setPath(String path) {
        this.path = this.normalize(path);
    }

    private String normalize(String path) {
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    public void installInto(final File targetLocation) {
        try {
            URI uri = URI.create("jar:" + String.valueOf(FileLocator.getBundleFile((Bundle)this.bundle).toURI()) + "!/");
            Files.createDirectories(targetLocation.toPath(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                final Path rootPath = fs.getPath(this.path, new String[0]);
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path destFile = Paths.get(targetLocation.toString(), rootPath.relativize(file).toString());
                        Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path dirToCreate = Paths.get(targetLocation.toString(), rootPath.relativize(dir).toString());
                        if (!dirToCreate.toFile().exists()) {
                            Files.createDirectory(dirToCreate, new FileAttribute[0]);
                        } else if (dir.getParent().equals(rootPath)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logWarning("Unexpected error while copying tooling cache. This will not affect studio functionality but it may take longer to start the first time.", e);
        }
    }

    private static class ToolingCacheExtensionsHolder {
        private static final List<ToolingCacheExtension> extensions = IExtensionPointReader.create(ToolingCacheExtension.class).readAll();

        private ToolingCacheExtensionsHolder() {
        }
    }
}

