/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.sax;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultText;
import org.mule.tooling.core.sax.ElementWithLocation;
import org.mule.tooling.core.sax.SAXReaderWithLocator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXUtils {
    private int index = 0;

    public void enumerate(Element element) {
        this.setIndex(0);
        this.doEnumerate(element);
    }

    private void doEnumerate(Element element) {
        if (element instanceof ElementWithLocation) {
            ElementWithLocation e = (ElementWithLocation)element;
            e.setIndex(this.index++);
        }
        List elements = element.elements();
        for (Object object : elements) {
            if (!(object instanceof Element)) continue;
            Element innerElement = (Element)object;
            this.doEnumerate(innerElement);
        }
    }

    public static Document parseXML(String text) throws DocumentException {
        SAXUtils saxUtils = new SAXUtils();
        Document result = null;
        SAXReaderWithLocator reader = new SAXReaderWithLocator();
        try {
            reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        String encoding = SAXUtils.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        try {
            result = reader.read(source);
        }
        catch (DocumentException e) {
            String message = e.getMessage();
            String string = "The prefix \"";
            int indexOf = message.indexOf(string);
            if (indexOf != -1) {
                String offendingPrefix;
                int indexOf2 = (message = message.substring(indexOf + string.length())).indexOf(34);
                if (indexOf2 != -1 && !"xml".equalsIgnoreCase(offendingPrefix = (message = message.substring(0, indexOf2))) && !"xmlns".equalsIgnoreCase(offendingPrefix)) {
                    return SAXUtils.parseXML(text.replace(offendingPrefix + ":", offendingPrefix + "-"));
                }
            }
            if (message.indexOf("Content is not allowed in prolog.") != -1) {
                ByteArrayInputStream ins = new ByteArrayInputStream(text.getBytes());
                BOMInputStream bomIn = new BOMInputStream((InputStream)ins);
                try {
                    source = new InputSource((InputStream)bomIn);
                    result = reader.read(source);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)ins);
                    IOUtils.closeQuietly((InputStream)bomIn);
                }
            }
            throw e;
        }
        saxUtils.enumerate(result.getRootElement());
        SAXUtils.inplaceUnescape(result.getRootElement());
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    public static void inplaceUnescape(Element element) {
        SAXUtils.inplaceTransformTree(element, new AttributeValueTransformer(){

            @Override
            public String transformAttributeValue(String orig) {
                return SAXUtils.unescape(orig);
            }
        });
    }

    public static void inplaceEscape(Element element) {
        SAXUtils.inplaceTransformTree(element, new AttributeValueTransformer(){

            @Override
            public String transformAttributeValue(String orig) {
                return SAXUtils.escape(orig);
            }
        });
    }

    public static String unescape(String orig) {
        return StringEscapeUtils.unescapeXml((String)orig);
    }

    public static String escape(String orig) {
        String escaped = StringEscapeUtils.escapeXml((String)orig);
        String escaped2 = escaped.replaceAll("&apos;", "'");
        return escaped2;
    }

    public static void inplaceTransformTree(Element element, AttributeValueTransformer f) {
        List as = element.attributes();
        ArrayList<DefaultAttribute> newAttributes = new ArrayList<DefaultAttribute>();
        for (Attribute a : as) {
            String oldValue = a.getValue();
            String newValue = f.transformAttributeValue(oldValue);
            QName name = a.getQName();
            DefaultAttribute newAttribute = new DefaultAttribute(name, newValue);
            newAttributes.add(newAttribute);
        }
        List content = element.content();
        for (Object object : content) {
            if (!(object instanceof DefaultText)) continue;
            DefaultText casted = (DefaultText)object;
            String text = casted.getText();
            String transformedAttributeValue = f.transformAttributeValue(text);
            casted.setText(transformedAttributeValue);
        }
        element.attributes().clear();
        element.attributes().addAll(newAttributes);
        List elements = element.elements();
        for (Element e : elements) {
            SAXUtils.inplaceTransformTree(e, f);
        }
    }

    public static Element createElement(QName qname) {
        return SAXReaderWithLocator.getDocumentFactoryInstance().createElement(qname);
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private static interface AttributeValueTransformer {
        public String transformAttributeValue(String var1);
    }
}

