/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.sax;

import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

public class SAXElementStack
implements ElementPath {
    protected Element[] stack;
    protected int lastElementIndex = -1;

    public SAXElementStack() {
        this(50);
    }

    public SAXElementStack(int defaultCapacity) {
        this.stack = new Element[defaultCapacity];
    }

    public void clear() {
        this.lastElementIndex = -1;
    }

    public Element peekElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex];
    }

    public Element popElement() {
        if (this.lastElementIndex < 0) {
            return null;
        }
        return this.stack[this.lastElementIndex--];
    }

    public void pushElement(Element element) {
        int length = this.stack.length;
        if (++this.lastElementIndex >= length) {
            this.reallocate(length * 2);
        }
        this.stack[this.lastElementIndex] = element;
    }

    protected void reallocate(int size) {
        Element[] oldStack = this.stack;
        this.stack = new Element[size];
        System.arraycopy(oldStack, 0, this.stack, 0, oldStack.length);
    }

    public int size() {
        return this.lastElementIndex + 1;
    }

    public Element getElement(int depth) {
        Element element;
        try {
            element = this.stack[depth];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            element = null;
        }
        return element;
    }

    public Element getCurrent() {
        return this.peekElement();
    }

    public String getPath() {
        return null;
    }

    public void addHandler(String path, ElementHandler handler) {
    }

    public void removeHandler(String path) {
    }
}

