/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.sax;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dtd.AttributeDecl;
import org.dom4j.dtd.Decl;
import org.dom4j.dtd.ElementDecl;
import org.dom4j.dtd.ExternalEntityDecl;
import org.dom4j.dtd.InternalEntityDecl;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.NamespaceStack;
import org.mule.tooling.core.sax.ElementWithLocation;
import org.mule.tooling.core.sax.SAXElementStack;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXContentHandlerWithLocator
extends SAXContentHandler {
    private DocumentFactory documentFactory;
    private Document document;
    private SAXElementStack elementStack;
    private NamespaceStack namespaceStack;
    private Locator locator;
    private String entity;
    private boolean insideDTDSection;
    private boolean insideCDATASection;
    private StringBuffer cdataText;
    private List internalDTDDeclarations;
    private List externalDTDDeclarations;
    private int declaredNamespaceIndex;
    private EntityResolver entityResolver;
    private InputSource inputSource;
    private Element currentElement;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private int entityLevel;
    private boolean internalDTDsubset = false;
    private boolean mergeAdjacentText = false;
    private boolean textInTextBuffer = false;
    private boolean ignoreComments = false;
    private StringBuffer textBuffer;
    private boolean stripWhitespaceText = false;

    public SAXContentHandlerWithLocator() {
        this(DocumentFactory.getInstance());
    }

    public SAXContentHandlerWithLocator(DocumentFactory documentFactory) {
        this(documentFactory, null);
    }

    public SAXContentHandlerWithLocator(DocumentFactory documentFactory, ElementHandler elementHandler) {
        this(documentFactory, elementHandler, null);
        this.elementStack = this.createSAXElementStack();
    }

    public SAXContentHandlerWithLocator(DocumentFactory documentFactory, ElementHandler elementHandler, SAXElementStack elementStack) {
        this.documentFactory = documentFactory;
        this.elementStack = elementStack;
        this.namespaceStack = new NamespaceStack(documentFactory);
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        return this.document;
    }

    public void setDocumentLocator(Locator documentLocator) {
        this.locator = documentLocator;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.currentElement != null) {
            this.currentElement.addProcessingInstruction(target, data);
        } else {
            this.getDocument().addProcessingInstruction(target, data);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceStack.push(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceStack.pop(prefix);
        this.declaredNamespaceIndex = this.namespaceStack.size();
    }

    public void startDocument() throws SAXException {
        this.document = null;
        this.currentElement = null;
        this.elementStack.clear();
        this.namespaceStack.clear();
        this.declaredNamespaceIndex = 0;
        if (this.mergeAdjacentText && this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textInTextBuffer = false;
    }

    public void endDocument() throws SAXException {
        this.namespaceStack.clear();
        this.elementStack.clear();
        this.currentElement = null;
        this.textBuffer = null;
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        Element element;
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        QName qName = this.namespaceStack.getQName(namespaceURI, localName, qualifiedName);
        Element branch = this.currentElement;
        if (branch == null) {
            branch = this.getDocument();
        }
        if ((element = branch.addElement(qName)) instanceof ElementWithLocation) {
            ElementWithLocation elementWithLocation = (ElementWithLocation)element;
            elementWithLocation.setLineNumber(this.locator.getLineNumber());
            elementWithLocation.setColumnNumber(this.locator.getColumnNumber());
        }
        this.addDeclaredNamespaces(element);
        this.addAttributes(element, attributes);
        this.elementStack.pushElement(element);
        this.currentElement = element;
        this.entity = null;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Element element;
        if (this.mergeAdjacentText && this.textInTextBuffer) {
            this.completeCurrentTextNode();
        }
        if (this.elementStack.size() > 0 && (element = this.elementStack.peekElement()) instanceof ElementWithLocation) {
            ElementWithLocation elementWithLocation = (ElementWithLocation)element;
            elementWithLocation.setEndLineNumber(this.locator.getLineNumber());
            elementWithLocation.setEndColumnNumber(this.locator.getColumnNumber());
        }
        this.elementStack.popElement();
        this.currentElement = this.elementStack.peekElement();
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        if (end == 0) {
            return;
        }
        if (this.currentElement != null) {
            if (this.entity != null) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.currentElement.addEntity(this.entity, new String(ch, start, end));
                this.entity = null;
            } else if (this.insideCDATASection) {
                if (this.mergeAdjacentText && this.textInTextBuffer) {
                    this.completeCurrentTextNode();
                }
                this.cdataText.append(new String(ch, start, end));
            } else if (this.mergeAdjacentText) {
                this.textBuffer.append(ch, start, end);
                this.textInTextBuffer = true;
            } else {
                this.currentElement.addText(new String(ch, start, end));
            }
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.getDocument().addDocType(name, publicId, systemId);
        this.insideDTDSection = true;
        this.internalDTDsubset = true;
    }

    public void endDTD() throws SAXException {
        this.insideDTDSection = false;
        DocumentType docType = this.getDocument().getDocType();
        if (docType != null) {
            if (this.internalDTDDeclarations != null) {
                docType.setInternalDeclarations(this.internalDTDDeclarations);
            }
            if (this.externalDTDDeclarations != null) {
                docType.setExternalDeclarations(this.externalDTDDeclarations);
            }
        }
        this.internalDTDDeclarations = null;
        this.externalDTDDeclarations = null;
    }

    public void startEntity(String name) throws SAXException {
        ++this.entityLevel;
        this.entity = null;
        if (!this.insideDTDSection && !this.isIgnorableEntity(name)) {
            this.entity = name;
        }
        this.internalDTDsubset = false;
    }

    public void endEntity(String name) throws SAXException {
        --this.entityLevel;
        this.entity = null;
        if (this.entityLevel == 0) {
            this.internalDTDsubset = true;
        }
    }

    public void startCDATA() throws SAXException {
        this.insideCDATASection = true;
        this.cdataText = new StringBuffer();
    }

    public void endCDATA() throws SAXException {
        this.insideCDATASection = false;
        this.currentElement.addCDATA(this.cdataText.toString());
    }

    public void comment(char[] ch, int start, int end) throws SAXException {
        if (!this.ignoreComments) {
            if (this.mergeAdjacentText && this.textInTextBuffer) {
                this.completeCurrentTextNode();
            }
            String text = new String(ch, start, end);
            if (!this.insideDTDSection && text.length() > 0) {
                if (this.currentElement != null) {
                    this.currentElement.addComment(text);
                } else {
                    this.getDocument().addComment(text);
                }
            }
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration((Decl)new ElementDecl(name, model));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration((Decl)new ElementDecl(name, model));
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String val) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration((Decl)new AttributeDecl(eName, aName, type, valueDefault, val));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration((Decl)new AttributeDecl(eName, aName, type, valueDefault, val));
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration((Decl)new InternalEntityDecl(name, value));
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration((Decl)new InternalEntityDecl(name, value));
        }
    }

    public void externalEntityDecl(String name, String publicId, String sysId) throws SAXException {
        ExternalEntityDecl declaration = new ExternalEntityDecl(name, publicId, sysId);
        if (this.internalDTDsubset) {
            if (this.includeInternalDTDDeclarations) {
                this.addDTDDeclaration((Decl)declaration);
            }
        } else if (this.includeExternalDTDDeclarations) {
            this.addExternalDTDDeclaration((Decl)declaration);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean include) {
        this.includeInternalDTDDeclarations = include;
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public void setIncludeExternalDTDDeclarations(boolean include) {
        this.includeExternalDTDDeclarations = include;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean mergeAdjacentText) {
        this.mergeAdjacentText = mergeAdjacentText;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean stripWhitespaceText) {
        this.stripWhitespaceText = stripWhitespaceText;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    protected void completeCurrentTextNode() {
        if (this.stripWhitespaceText) {
            boolean whitespace = true;
            int i = 0;
            int size = this.textBuffer.length();
            while (i < size) {
                if (!Character.isWhitespace(this.textBuffer.charAt(i))) {
                    whitespace = false;
                    break;
                }
                ++i;
            }
            if (!whitespace) {
                this.currentElement.addText(this.textBuffer.toString());
            }
        } else {
            this.currentElement.addText(this.textBuffer.toString());
        }
        this.textBuffer.setLength(0);
        this.textInTextBuffer = false;
    }

    protected Document createDocument() {
        String encoding = this.getEncoding();
        Document doc = this.documentFactory.createDocument(encoding);
        doc.setEntityResolver(this.entityResolver);
        if (this.inputSource != null) {
            doc.setName(this.inputSource.getSystemId());
        }
        return doc;
    }

    private String getEncoding() {
        if (this.locator == null) {
            return null;
        }
        try {
            Method m = this.locator.getClass().getMethod("getEncoding", new Class[0]);
            if (m != null) {
                return (String)m.invoke((Object)this.locator, null);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected boolean isIgnorableEntity(String name) {
        return "amp".equals(name) || "apos".equals(name) || "gt".equals(name) || "lt".equals(name) || "quot".equals(name);
    }

    protected void addDeclaredNamespaces(Element element) {
        int size = this.namespaceStack.size();
        while (this.declaredNamespaceIndex < size) {
            Namespace namespace = this.namespaceStack.getNamespace(this.declaredNamespaceIndex);
            element.add(namespace);
            ++this.declaredNamespaceIndex;
        }
    }

    protected void addAttributes(Element element, Attributes attributes) {
        boolean noNamespaceAttributes = false;
        if (element instanceof AbstractElement) {
            AbstractElement baseElement = (AbstractElement)element;
            baseElement.setAttributes(attributes, this.namespaceStack, noNamespaceAttributes);
        } else {
            int size = attributes.getLength();
            int i = 0;
            while (i < size) {
                String attributeQName = attributes.getQName(i);
                if (noNamespaceAttributes || !attributeQName.startsWith("xmlns")) {
                    String attributeURI = attributes.getURI(i);
                    String attributeLocalName = attributes.getLocalName(i);
                    String attributeValue = attributes.getValue(i);
                    QName qName = this.namespaceStack.getAttributeQName(attributeURI, attributeLocalName, attributeQName);
                    element.addAttribute(qName, attributeValue);
                }
                ++i;
            }
        }
    }

    protected void addDTDDeclaration(Object declaration) {
        if (this.internalDTDDeclarations == null) {
            this.internalDTDDeclarations = new ArrayList();
        }
        this.internalDTDDeclarations.add(declaration);
    }

    protected void addExternalDTDDeclaration(Object declaration) {
        if (this.externalDTDDeclarations == null) {
            this.externalDTDDeclarations = new ArrayList();
        }
        this.externalDTDDeclarations.add(declaration);
    }

    protected SAXElementStack createSAXElementStack() {
        return new SAXElementStack();
    }
}

