/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.sax;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.NamespaceStack;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.DOMFactory;
import org.mule.tooling.core.sax.ElementWithLocation;
import org.mule.tooling.core.sax.SAXUtils;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.xml.sax.Attributes;

public class ElementWithLocation0
extends DefaultElement
implements ElementWithLocation {
    private static final Comparator<Element> flowsAndGlobalsComparator = new Comparator<Element>(){

        @Override
        public int compare(Element lhs, Element rhs) {
            return this.weight(lhs) - this.weight(rhs);
        }

        int weight(Element e) {
            String runtimeVersion = MuleCorePlugin.getDesignContext().getMuleProject().getServerDefinition().getVersion();
            NodeDefinition definitionForElement = MuleCorePlugin.getModuleManager().getDefinitionForElement(DOMFactory.from(e), runtimeVersion);
            if (definitionForElement instanceof GlobalDefinition) {
                return 0;
            }
            return 1;
        }
    };
    private static final Comparator<Element> indexComparator = (lhs, rhs) -> {
        Attribute la = lhs.attribute(";INDEX");
        int li = la == null ? Integer.MAX_VALUE : Integer.parseInt(la.getValue());
        Attribute ra = rhs.attribute(";INDEX");
        int ri = ra == null ? Integer.MAX_VALUE : Integer.parseInt(ra.getValue());
        return li - ri;
    };
    private static final long serialVersionUID = -5001495065715920069L;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private int index = -1;
    private int endLineNumber = -1;
    private int endColumnNumber = -1;
    private int wrapIn = -1;
    private ArrayList<Element> el;
    private boolean isNested;
    private String preparedText;
    private int oldLevel = -1;
    private boolean unknown = false;
    private boolean isAttribute = false;
    private boolean generated = false;
    private Set<String> childAttributes = new HashSet<String>();
    private String wrappedIn = null;
    private boolean generatedFromUnknown = false;

    public ElementWithLocation0(QName qname) {
        super(qname);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int evalIndex() {
        if (this.index != -1) {
            return this.index;
        }
        String indexValue = this.attributeValue(";INDEX");
        if (indexValue == null) {
            return -1;
        }
        return Integer.parseInt(indexValue);
    }

    private static int evalIndex(Element element) {
        return element instanceof ElementWithLocation ? ((ElementWithLocation)element).evalIndex() : -1;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getEndLineNumber() {
        return this.endLineNumber;
    }

    @Override
    public void setEndLineNumber(int lineNumber2) {
        this.endLineNumber = lineNumber2;
    }

    @Override
    public int getEndColumnNumber() {
        return this.endColumnNumber;
    }

    @Override
    public void setEndColumnNumber(int columnNumber2) {
        this.endColumnNumber = columnNumber2;
    }

    @Override
    public int getWrapIn() {
        return this.wrapIn;
    }

    @Override
    public void setWrapIn(int wrapIn) {
        this.wrapIn = wrapIn;
    }

    @Override
    public List<Element> elementsOrdered() {
        if (this.el != null) {
            return this.el;
        }
        this.el = new ArrayList(this.elements());
        if (ElementWithLocation0.onlyNestedElements(this.elements())) {
            Collections.sort(this.el, indexComparator);
        } else {
            ElementWithLocation0.sortNestedElements(this.el);
        }
        Collections.sort(this.el, flowsAndGlobalsComparator);
        this.el = ElementWithLocation0.unique(this.el);
        return this.el;
    }

    private static ArrayList unique(ArrayList el2) {
        ArrayList el = el2;
        ArrayList<ElementWithLocation> result = new ArrayList<ElementWithLocation>();
        for (ElementWithLocation e : el) {
            if (ElementWithLocation0.contains(result, e) && e.evalIndex() > 0) continue;
            result.add(e);
        }
        return result;
    }

    private static boolean contains(ArrayList<ElementWithLocation> list, ElementWithLocation e) {
        for (ElementWithLocation e2 : list) {
            if (e.evalIndex() != e2.evalIndex()) continue;
            return true;
        }
        return false;
    }

    private static void sortNestedElements(ArrayList<Element> el2) {
        ArrayList<Element> sorted = new ArrayList<Element>();
        for (Element e : el2) {
            int index;
            boolean isNested = ElementWithLocation0.isNested(e);
            int n = index = !isNested ? -1 : ElementWithLocation0.evalIndex(e);
            if (isNested && index != -1) {
                int i = 0;
                while (i < sorted.size() && ElementWithLocation0.evalIndex((Element)sorted.get(i)) < ElementWithLocation0.evalIndex(e)) {
                    ++i;
                }
                sorted.add(i, e);
                continue;
            }
            sorted.add(e);
        }
        el2.clear();
        el2.addAll(sorted);
    }

    private static boolean onlyNestedElements(List<Element> elements) {
        for (Element e : elements) {
            if (ElementWithLocation0.isNested(e)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNested(Element e) {
        if (e instanceof ElementWithLocation) {
            return ((ElementWithLocation)e).isNested();
        }
        return false;
    }

    @Override
    public boolean isNested() {
        return this.isNested;
    }

    @Override
    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeValue(name) != null;
    }

    @Override
    public String getPreparedText() {
        return this.preparedText;
    }

    @Override
    public void setPreparedText(String preparedText) {
        this.preparedText = preparedText;
    }

    @Override
    public int getOldLevel() {
        return this.oldLevel;
    }

    @Override
    public void setOldLevel(int oldLevel) {
        this.oldLevel = oldLevel;
    }

    @Override
    public boolean isUnknown() {
        return this.unknown || this.getQualifiedName() != null && this.getQualifiedName().equals("description");
    }

    @Override
    public void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    private static void toString(StringBuilder sb, ElementWithLocation e, int level) {
        String index;
        boolean newElementHasIndex;
        String prefix = StringUtils.repeat((String)" ", (int)(2 * level));
        sb.append(prefix);
        int idx = e.evalIndex();
        if (idx != -1) {
            sb.append("[");
            sb.append(idx);
            sb.append("] ");
        }
        boolean bl = newElementHasIndex = (index = e.attributeValue(";INDEX")) != null;
        if (newElementHasIndex) {
            int newElementIndex = Integer.parseInt(index);
            sb.append("-> ");
            sb.append(newElementIndex);
            sb.append(' ');
        }
        sb.append(e.getQName().getQualifiedName());
        if (e.isUnknown()) {
            sb.append(" (unknown)");
        }
        sb.append('\n');
        List es = e.elements();
        for (Element f : es) {
            if (f instanceof ElementWithLocation) {
                ElementWithLocation el = (ElementWithLocation)f;
                ElementWithLocation0.toString(sb, el, level + 1);
                continue;
            }
            throw new IllegalStateException("Unsuported element type:" + String.valueOf(f.getClass()));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        ElementWithLocation0.toString(sb, this, 0);
        return sb.toString();
    }

    @Override
    public boolean isAttribute() {
        return this.isAttribute;
    }

    @Override
    public void setAttribute(boolean isAttribute) {
        this.isAttribute = isAttribute;
    }

    protected ElementWithLocation0 createElement(QName qName) {
        return new ElementWithLocation0(qName);
    }

    @Override
    public ElementWithLocation createCopy() {
        ElementWithLocation copy = (ElementWithLocation)super.createCopy();
        copy.setLineNumber(this.lineNumber);
        copy.setColumnNumber(this.columnNumber);
        copy.setIndex(this.index);
        copy.setEndLineNumber(this.endLineNumber);
        copy.setEndColumnNumber(this.endColumnNumber);
        copy.setWrapIn(this.wrapIn);
        copy.setNested(this.isNested);
        copy.setPreparedText(this.preparedText);
        copy.setOldLevel(this.oldLevel);
        copy.setUnknown(this.unknown);
        copy.setAttribute(this.isAttribute);
        copy.setGenerated(this.generated);
        copy.setChildAttributes(this.childAttributes);
        copy.setWrappedIn(this.wrappedIn);
        return copy;
    }

    public void setAttributes(Attributes attributes, NamespaceStack namespaceStack, boolean noNamespaceAttributes) {
        int size = attributes.getLength();
        if (size > 0) {
            DocumentFactory factory = this.getDocumentFactory();
            if (size == 1) {
                String name = attributes.getQName(0);
                if (noNamespaceAttributes || !name.startsWith("xmlns")) {
                    String attributeURI = attributes.getURI(0);
                    String attributeLocalName = attributes.getLocalName(0);
                    String attributeValue = attributes.getValue(0);
                    QName attributeQName = namespaceStack.getAttributeQName(attributeURI, attributeLocalName, name);
                    this.add(factory.createAttribute((Element)this, attributeQName, attributeValue));
                }
            } else {
                List list = this.attributeList(size);
                list.clear();
                Object fAttributes = ElementWithLocation0.getFieldValue(attributes, "fAttributes");
                Object[] fAttributes2 = (Object[])(fAttributes == null ? null : ElementWithLocation0.getFieldValue(fAttributes, "fAttributes"));
                int i = 0;
                while (i < size) {
                    String attributeName = attributes.getQName(i);
                    if (noNamespaceAttributes || !attributeName.startsWith("xmlns")) {
                        Object origAttribute;
                        String origAttributeValue;
                        String attributeURI = attributes.getURI(i);
                        String attributeLocalName = attributes.getLocalName(i);
                        String attributeValue = attributes.getValue(i);
                        if (fAttributes2 != null && (origAttributeValue = (String)ElementWithLocation0.getFieldValue(origAttribute = fAttributes2[i], "nonNormalizedValue")) != null) {
                            attributeValue = origAttributeValue;
                            attributeValue = SAXUtils.unescape(attributeValue);
                        }
                        QName attributeQName = namespaceStack.getAttributeQName(attributeURI, attributeLocalName, attributeName);
                        Attribute attribute = factory.createAttribute((Element)this, attributeQName, attributeValue);
                        list.add(attribute);
                        this.childAdded((Node)attribute);
                    }
                    ++i;
                }
            }
        }
    }

    private static Object getFieldValue(Object obj, String fieldName) {
        Class<?> klass = obj.getClass();
        try {
            Field field = klass.getDeclaredField(fieldName);
            boolean oldAccessible = field.isAccessible();
            field.setAccessible(true);
            Object result = field.get(obj);
            field.setAccessible(oldAccessible);
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    @Override
    public Set<String> getChildAttributes() {
        return this.childAttributes;
    }

    @Override
    public void setChildAttributes(Set<String> childAttributes) {
        this.childAttributes = childAttributes;
    }

    @Override
    public void setGenerated(boolean b) {
        this.generated = b;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public void setWrappedIn(String wrappedIn) {
        this.wrappedIn = wrappedIn;
    }

    @Override
    public String getWrappedIn() {
        return this.wrappedIn;
    }

    public void setGeneratedFromUnknown(boolean generatedFromUnknown) {
        this.generatedFromUnknown = generatedFromUnknown;
    }

    @Override
    public boolean isGeneratedFromUnknown() {
        return this.generatedFromUnknown;
    }
}

