/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.sax;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;
import org.mule.tooling.core.dom.IElementWrapper;

public class ElementUtils {
    public static boolean isDocumentationElement(IElementWrapper element) {
        return element.getName().equals("description") && "http://www.mulesoft.org/schema/mule/core".equals(element.getQName().getNamespaceURI());
    }

    public static String getTextOf(Element element) {
        StringBuilder textBuilder = new StringBuilder();
        List content = element.content();
        for (Object object : content) {
            if (object instanceof CDATA) {
                CDATA cdata = (CDATA)object;
                textBuilder.append(cdata.getText());
                continue;
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (node.getNodeType() != 3 || StringUtils.isBlank((String)node.getText())) continue;
                textBuilder.append(node.getText());
                continue;
            }
            throw new IllegalArgumentException("Invalid node type");
        }
        return textBuilder.toString();
    }
}

