/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources.internal;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.sources.ClasspathEntryClassifier;
import org.mule.tooling.core.runtime.sources.internal.DependencyCache;
import org.mule.tooling.core.utils.BundleJarFileInspector;
import org.mule.tooling.osgi.services.ServicesRegistry;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspectorService;

public abstract class JarFileEntryClassifier
implements ClasspathEntryClassifier {
    protected static MavenJarFileInspectorService getMavenJarInspectorService() {
        MavenJarFileInspectorService mavenJarInspectorService = ServicesRegistry.get().getMavenJarInspectorService();
        return mavenJarInspectorService != null ? mavenJarInspectorService : new BundleJarFileInspectorService();
    }

    @Override
    public boolean classifies(IServerDefinition definition, IPath entryPath) {
        Optional<MavenDependency> maybeDependency;
        boolean classifies = false;
        if (this.isExistingJar(entryPath) && (maybeDependency = DependencyCache.getOrComputeMavenDependency(entryPath, x -> {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (JarFile jarFile = this.getJarFile(definition, entryPath);){
                    MavenJarFileInspector inspector = JarFileEntryClassifier.getMavenJarInspectorService().getInspector(jarFile);
                    return ((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(inspector.getGroupId())).build();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return null;
            }
        })).isPresent()) {
            classifies = this.doClassifies(definition, entryPath, maybeDependency.get().getGroupId());
        }
        return classifies;
    }

    protected abstract boolean doClassifies(IServerDefinition var1, IPath var2, String var3);

    protected boolean isExistingJar(IPath entryPath) {
        return entryPath != null && entryPath.toOSString().endsWith(".jar") && entryPath.toFile().exists();
    }

    protected JarFile getJarFile(IServerDefinition definition, IPath path) {
        File jarFile;
        File file = jarFile = path != null ? path.toFile() : null;
        if (jarFile == null || !jarFile.exists()) {
            throw new IllegalArgumentException("Non-existent jar file " + String.valueOf(jarFile) + " referenced by server " + String.valueOf(definition));
        }
        try {
            return new JarFile(jarFile);
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Couldn't open jar file " + String.valueOf(path), e);
            return null;
        }
    }

    private static final class BundleJarFileInspectorService
    implements MavenJarFileInspectorService {
        private BundleJarFileInspectorService() {
        }

        public MavenJarFileInspector getInspector(JarFile file) {
            return new BundleJarFileInspector(file);
        }
    }
}

