/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources.internal;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;

public class CachingJarFile
extends JarFile {
    private CachingEnumeration cachedEnumeration;
    private File file;
    private boolean sourceClosed;
    private Map<String, byte[]> contentsCache = new HashMap<String, byte[]>();
    private CachingJarFile postMortemFile;

    public CachingJarFile(File file) throws IOException {
        super(file);
        this.file = file;
    }

    @Override
    public Enumeration<JarEntry> entries() {
        if (this.cachedEnumeration == null) {
            this.cachedEnumeration = new CachingEnumeration(this.getSourceEntries());
        } else {
            this.cachedEnumeration.reset();
        }
        return this.cachedEnumeration;
    }

    private Enumeration<JarEntry> getSourceEntries() {
        Enumeration<JarEntry> entries = !this.sourceClosed ? super.entries() : this.getPostMortemFile().entries();
        return entries;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry entry) throws IOException {
        String entryName = entry.getName();
        if (!this.contentsCache.containsKey(entryName)) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream inputStream = this.doGetEntryContents(entry);){
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                this.contentsCache.put(entryName, byteArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new ByteArrayInputStream(this.contentsCache.get(entryName));
    }

    private InputStream doGetEntryContents(ZipEntry entry) throws IOException {
        InputStream inputStream = !this.sourceClosed ? super.getInputStream(entry) : this.getPostMortemFile().getInputStream(entry);
        return inputStream;
    }

    private CachingJarFile getPostMortemFile() {
        if (this.postMortemFile == null) {
            try {
                this.postMortemFile = new CachingJarFile(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.postMortemFile;
    }

    @Override
    public void close() throws IOException {
        this.sourceClosed = true;
        IOUtils.closeQuietly((Closeable)this.cachedEnumeration);
        IOUtils.closeQuietly((Closeable)this.postMortemFile);
        this.postMortemFile = null;
        super.close();
    }

    private class CachingEnumeration
    implements Enumeration<JarEntry>,
    Closeable {
        private Enumeration<JarEntry> source;
        private boolean sourceClosed;
        private List<JarEntry> cachedElements = new ArrayList<JarEntry>();
        private int currentIndex = 0;
        private boolean depleted;

        public CachingEnumeration(Enumeration<JarEntry> sourceEntries) {
            this.source = sourceEntries;
        }

        public void reset() {
            this.currentIndex = 0;
            this.depleted = false;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.depleted) {
                return false;
            }
            if (this.currentIndex < this.cachedElements.size()) {
                return true;
            }
            if (this.sourceClosed) {
                boolean hasMoreElements = this.getSource().hasMoreElements();
                this.depleted = !hasMoreElements;
                return hasMoreElements;
            }
            return this.getSource().hasMoreElements();
        }

        @Override
        public void close() {
            this.sourceClosed = true;
            this.source = null;
            this.reset();
        }

        private Enumeration<JarEntry> getSource() {
            if (this.source == null && this.sourceClosed) {
                this.source = CachingJarFile.this.getPostMortemFile().getSourceEntries();
            }
            return this.source;
        }

        @Override
        public JarEntry nextElement() {
            JarEntry element;
            if (this.currentIndex < this.cachedElements.size()) {
                element = this.cachedElements.get(this.currentIndex++);
            } else {
                element = this.source.nextElement();
                this.cachedElements.add(element);
            }
            return element;
        }
    }
}

