/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources;

import com.google.common.base.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.sources.ClasspathEntryKind;
import org.mule.tooling.core.runtime.sources.SourceAttachmentPreferences;
import org.mule.tooling.core.runtime.sources.SourceAttachmentProvider;

public class StaticSourceAttachmentProvider
implements SourceAttachmentProvider {
    @Override
    public Optional<IPath> getSourceAttachment(IPath path, IServerDefinition server) {
        IPath sourceAttachmentPath = null;
        if (ClasspathEntryKind.COMMUNITY.classifies(server, path)) {
            sourceAttachmentPath = server.getSourceFilePath();
        } else if (ClasspathEntryKind.ENTERPRISE.classifies(server, path)) {
            sourceAttachmentPath = server.getEnterpriseSourceFilePath();
        } else if (ClasspathEntryKind.THIRDPARTY.classifies(server, path)) {
            String sourceAttachment = SourceAttachmentPreferences.get().getSourceAttachment(server, path);
            sourceAttachmentPath = !sourceAttachment.isEmpty() ? Path.fromOSString((String)sourceAttachment) : null;
        }
        return Optional.fromNullable((Object)sourceAttachmentPath);
    }
}

