/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.mule.tooling.core.runtime.sources.SourceAttachmentProvider;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

@ExtensionPoint(extensionPointId="org.mule.tooling.core.sourceAttachmentProvider")
public class SourceAttachmentProviderExtension {
    @ExtensionAttribute
    private SourceAttachmentProvider provider;
    @ExtensionAttribute(optional=true)
    private Integer priority = 10;

    public static List<SourceAttachmentProvider> getProviders() {
        return Singleton.providers;
    }

    private static List<SourceAttachmentProvider> doGetProviders() {
        List extensions = IExtensionPointReader.create(SourceAttachmentProviderExtension.class).readAll();
        Collections.sort(extensions, SourceAttachmentProviderExtension.byPriority());
        return (List)CollectionUtils.collect((Collection)extensions, (Transformer)SourceAttachmentProviderExtension.getProviderFromExtension());
    }

    public SourceAttachmentProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SourceAttachmentProvider provider) {
        this.provider = provider;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    private static Transformer getProviderFromExtension() {
        return new Transformer(){

            public Object transform(Object input) {
                return ((SourceAttachmentProviderExtension)input).getProvider();
            }
        };
    }

    private static Comparator<SourceAttachmentProviderExtension> byPriority() {
        return new Comparator<SourceAttachmentProviderExtension>(){

            @Override
            public int compare(SourceAttachmentProviderExtension o1, SourceAttachmentProviderExtension o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        };
    }

    private static class Singleton {
        private static final List<SourceAttachmentProvider> providers = SourceAttachmentProviderExtension.doGetProviders();

        private Singleton() {
        }
    }
}

