/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources;

import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class SourceAttachmentPreferences {
    private static final String THIRDPARTY_ATTACHMENTS_KEY = "thirdparty";
    private static final String SOURCE_ATTACHMENTS_KEY = "source_attachments";
    private Preferences preferenceStore;

    public static SourceAttachmentPreferences get() {
        return new SourceAttachmentPreferences();
    }

    private SourceAttachmentPreferences() {
        this(InstanceScope.INSTANCE.getNode("org.mule.tooling.core").node(SOURCE_ATTACHMENTS_KEY));
    }

    public SourceAttachmentPreferences(Preferences node) {
        this.preferenceStore = node;
    }

    public Optional<String> getSourceAttachment(String serverId) {
        String storedValue = this.preferenceStore.get(serverId, "");
        return storedValue.isEmpty() ? Optional.empty() : Optional.of(storedValue);
    }

    public void setSourceAttachment(IServerDefinition serverDefinition, IPath attachment) {
        this.preferenceStore.put(serverDefinition.getId(), attachment.toOSString());
    }

    public void setSourceAttachment(IServerDefinition serverDefinition, IPath libraryFullPath, IPath sourceAttachmentPath) {
        this.getThirdPartyLibrariesNode().put(this.getKeyForPreferences(libraryFullPath), sourceAttachmentPath.toOSString());
    }

    private Preferences getThirdPartyLibrariesNode() {
        return this.preferenceStore.node(THIRDPARTY_ATTACHMENTS_KEY);
    }

    public String getSourceAttachment(IServerDefinition server, IPath libraryFullPath) {
        return this.getThirdPartyLibrariesNode().get(this.getKeyForPreferences(libraryFullPath), Path.EMPTY.toOSString());
    }

    private String getKeyForPreferences(IPath libraryFullPath) {
        return libraryFullPath.lastSegment();
    }

    public boolean save() {
        try {
            this.preferenceStore.flush();
            return true;
        }
        catch (BackingStoreException e) {
            MuleCorePlugin.logError("There was a problem saving source attachment preferences", e);
            return false;
        }
    }
}

