/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.sources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.sources.internal.CachingJarFile;

public class JarFileCache {
    private static final int CACHE_SIZE_PER_RT_RATIO = 300;
    private static final int EVICTION_TIME_FROM_FIRST_REQUEST = 30;
    private ThreadLocal<LoadingCache<File, JarFile>> mapCache = ThreadLocal.withInitial(() -> {
        int serverCount = MuleCorePlugin.getServerManager().getServerDefinitions().size();
        return CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).maximumSize((long)(serverCount * 300)).build((CacheLoader)new CacheLoader<File, JarFile>(){

            public JarFile load(File key) throws Exception {
                return new CachingJarFile(key);
            }
        });
    });

    public static JarFileCache instance() {
        return Singleton.instance;
    }

    private JarFileCache() {
    }

    public JarFile getJarFile(File file) throws IOException {
        try {
            return (JarFile)this.getMapCache().get((Object)file);
        }
        catch (ExecutionException e) {
            throw this.handle(e);
        }
    }

    private IOException handle(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        return new IOException(cause != null ? cause : e);
    }

    public void invalidateAll() {
        this.getMapCache().invalidateAll();
    }

    private LoadingCache<File, JarFile> getMapCache() {
        return this.mapCache.get();
    }

    private static class Singleton {
        private static final JarFileCache instance = new JarFileCache();

        private Singleton() {
        }
    }
}

