/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server.extensionpoint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.runtime.server.extensionpoint.FolderDefinition;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.utils.extensionpoint.ExtensionContext;

public class ServiceFolderDefinition
extends FolderDefinition {
    private Collection<LibraryFolderDefinition> libraryFolderDefinitions = Collections.emptyList();

    @Override
    public void initialize(ExtensionContext extensionContext) {
        super.initialize(extensionContext);
        File bundleRoot = extensionContext.getBundleRoot();
        File serviceDirectory = new File(bundleRoot, this.getPath());
        if (serviceDirectory.exists()) {
            try {
                this.libraryFolderDefinitions = this.getLibraryDefinitionsFromServicesFolder(extensionContext, serviceDirectory);
            }
            catch (IOException e) {
                MuleCorePlugin.logError("There was an error unzipping a mule service file while loading a server definition", e);
            }
        }
    }

    public Collection<LibraryFolderDefinition> getLibraryFolderDefinitions() {
        return this.libraryFolderDefinitions;
    }

    private Collection<LibraryFolderDefinition> getLibraryDefinitionsFromServicesFolder(ExtensionContext extensionContext, File serviceDirectory) throws IOException {
        File[] services;
        ArrayList<LibraryFolderDefinition> libDefinitions = new ArrayList<LibraryFolderDefinition>();
        File[] fileArray = services = serviceDirectory.listFiles();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            File serviceJar = fileArray[n2];
            LibraryFolderDefinition libDefinition = new LibraryFolderDefinition();
            String baseName = FilenameUtils.getBaseName((String)serviceJar.getName());
            libDefinition.setLabel(baseName);
            libDefinition.setIncludeInContainer(true);
            File containerFolder = extensionContext.getBundle().getDataFile(baseName);
            containerFolder.mkdirs();
            this.copyDataToFolder(serviceJar, containerFolder);
            IPath servicePath = Path.fromOSString((String)serviceJar.getPath()).makeAbsolute();
            libDefinition.addJarPath(servicePath);
            libDefinition.setAbsolutePath(containerFolder.getAbsolutePath());
            File librariesFolder = new File(containerFolder, "lib");
            if (librariesFolder.isDirectory()) {
                File[] libraries;
                File[] fileArray2 = libraries = librariesFolder.listFiles();
                int n3 = libraries.length;
                int n4 = 0;
                while (n4 < n3) {
                    File lib = fileArray2[n4];
                    String pathUrl = lib.getPath();
                    IPath portablePath = Path.fromOSString((String)pathUrl).makeAbsolute();
                    libDefinition.addJarPath(portablePath);
                    ++n4;
                }
            }
            libDefinitions.add(libDefinition);
            ++n2;
        }
        return libDefinitions;
    }

    private void copyDataToFolder(File serviceFile, File containerFolder) throws IOException {
        if (serviceFile.isDirectory()) {
            StudioFileUtils.copyFiles(serviceFile, containerFolder);
        } else {
            String extension = FilenameUtils.getExtension((String)serviceFile.getAbsolutePath());
            if ("jar".equalsIgnoreCase(extension)) {
                MuleResourceUtils.unzip(serviceFile.toPath(), containerFolder.toPath());
            }
        }
    }
}

