/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server.extensionpoint;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.ConfigFolderDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.runtime.server.SchemaLocationLookupExtension;
import org.mule.tooling.core.runtime.server.ServerDefinition;
import org.mule.tooling.core.runtime.server.defaultextensions.internal.RuntimeDefaultExtensionsExtension;
import org.mule.tooling.core.runtime.server.extensionpoint.MatchingServerDefinition;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerDefinitionBaseExtension;
import org.mule.tooling.core.runtime.server.extensionpoint.ServiceFolderDefinition;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.osgi.framework.Bundle;

@ExtensionPoint(extensionPointId="org.mule.tooling.runtime", elementName="server")
public class ServerDefinitionExtension
extends ServerDefinitionBaseExtension {
    @Inject
    private Bundle bundle;
    @ExtensionAttribute(attributeName="label")
    private String label;
    @ExtensionAttribute(attributeName="versionSuffix")
    private String versionSuffix;
    @ExtensionAttribute(attributeName="debuggerVersion")
    private String debuggerVersion;
    @ExtensionAttribute(attributeName="sourcePath")
    private String sourcePath;
    @ExtensionChildElement(childElementsName="libraryFolder", elementType=LibraryFolderDefinition.class)
    private List<LibraryFolderDefinition> libraryFolders;
    @ExtensionChildElement(childElementsName="serviceFolder", elementType=ServiceFolderDefinition.class)
    private List<ServiceFolderDefinition> serviceFolders;
    @ExtensionChildElement(childElementsName="configFolder", elementType=ConfigFolderDefinition.class)
    private List<ConfigFolderDefinition> configFolders;
    @ExtensionChildElement(childElementsName="configFolder", elementType=ClasspathElementDefinition.class)
    private List<ClasspathElementDefinition> classpathElements;
    @ExtensionPoint(extensionPointId="org.mule.tooling.servers.commons.schemaLocationLookup", cacheable=true, type=SchemaLocationLookupExtension.class, collectorFeatures={MatchingServerDefinition.class})
    private List<SchemaLocationLookupExtension> schemaLocationLookups;
    @ExtensionPoint(extensionPointId="org.mule.tooling.runtime.defaults", cacheable=true, type=RuntimeDefaultExtensionsExtension.class, collectorFeatures={MatchingServerDefinition.class})
    private List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions;

    public void initialize(ExtensionContext extensionContext) {
        try {
            if (this.serviceFolders == null || this.serviceFolders.isEmpty()) {
                this.serviceFolders = Arrays.asList(this.createDefaultServiceFolder(extensionContext));
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem loading the default service folder for server extension in bundle " + String.valueOf(extensionContext.getBundle()), e);
        }
    }

    public ServerDefinition buildServerDefinition() throws IOException, CoreException {
        return ServerDefinition.builder(this.bundle).withId(this.serverId).withLabel(this.label).withVersion(this.version).withSourceFilePath(this.sourcePath).withVersionSuffix(this.versionSuffix).withDebuggerVersion(this.debuggerVersion).enterpriseRuntime(this.isEnterprise).withLibraryFolders(this.libraryFolders).withConfigFolders(this.configFolders).withServiceFolders(this.serviceFolders).withClasspathElements(this.classpathElements).withSchemaLocationLookups(this.schemaLocationLookups).withRuntimeDefaultExtensions(this.runtimeDefaultExtensions).build();
    }

    private ServiceFolderDefinition createDefaultServiceFolder(ExtensionContext extensionContext) throws IOException {
        ServiceFolderDefinition defaultServiceFolder = new ServiceFolderDefinition();
        defaultServiceFolder.setLabel("Mule Services");
        defaultServiceFolder.setPath("mule/services");
        System.nanoTime();
        defaultServiceFolder.initialize(extensionContext);
        return defaultServiceFolder;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setVersionSuffix(String versionSuffix) {
        this.versionSuffix = versionSuffix;
    }

    public void setDebuggerVersion(String debuggerVersion) {
        this.debuggerVersion = debuggerVersion;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setLibraryFolders(List<LibraryFolderDefinition> libraryFolders) {
        this.libraryFolders = libraryFolders;
    }

    public void setServiceFolders(List<ServiceFolderDefinition> serviceFolders) {
        this.serviceFolders = serviceFolders;
    }

    public void setConfigFolders(List<ConfigFolderDefinition> configFolders) {
        this.configFolders = configFolders;
    }

    public void setClasspathElements(List<ClasspathElementDefinition> classpathElements) {
        this.classpathElements = classpathElements;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setSchemaLocationLookups(List<SchemaLocationLookupExtension> schemaLocationLookups) {
        this.schemaLocationLookups = schemaLocationLookups;
    }

    public void setRuntimeDefaultExtensions(List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions) {
        this.runtimeDefaultExtensions = runtimeDefaultExtensions;
    }
}

