/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server.extensionpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.ConfigFolderDefinition;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.runtime.server.MuleLauncherClasspathElement;
import org.mule.tooling.core.runtime.server.defaultextensions.RuntimeDefaultExtensions;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerDefinitionBaseExtension;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerFiltering;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.features.ExtensionPointCollectorFeature;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;

public class MatchingServerDefinition
implements ExtensionPointCollectorFeature {
    public <T> List<T> collect(List<T> readObjects, IExtensionReadingContext<T> readingContext, List<DefaultExtensionContext<T>> rootContexts) {
        ArrayList<T> result = new ArrayList<T>(readObjects.size());
        IServerDefinition server = this.getServerDefinitionFromContext(readingContext);
        for (T extension : readObjects) {
            if (extension instanceof ServerFiltering) {
                ServerFiltering serverFilteringExtension = (ServerFiltering)extension;
                if (!serverFilteringExtension.matches(server)) continue;
                result.add(extension);
                continue;
            }
            throw new IllegalArgumentException("extension points with the " + MatchingServerDefinition.class.getName() + " feature must implement " + ServerFiltering.class.getName());
        }
        return result;
    }

    private IServerDefinition getServerDefinitionFromContext(IExtensionReadingContext<?> readingContext) {
        DefaultExtensionContext serverDefinitionContext = readingContext.getParentContext().getCurrentExtensionContext();
        Object extensionObject = serverDefinitionContext.getExtensionObject();
        if (extensionObject instanceof ServerDefinitionBaseExtension) {
            ServerDefinitionBaseExtension serverDefinitionExtension = (ServerDefinitionBaseExtension)extensionObject;
            return new BasicServerDefinition(serverDefinitionExtension);
        }
        throw new IllegalStateException(MatchingServerDefinition.class.getName() + " feature can only be used from extensions that extend from " + ServerDefinitionBaseExtension.class.getName());
    }

    private static class BasicServerDefinition
    implements IServerDefinition {
        private ServerDefinitionBaseExtension serverDefinitionExtension;

        public BasicServerDefinition(ServerDefinitionBaseExtension extension) {
            this.serverDefinitionExtension = extension;
        }

        @Override
        public String getId() {
            return this.serverDefinitionExtension.getServerId();
        }

        @Override
        public String getVersion() {
            return this.serverDefinitionExtension.getVersion();
        }

        @Override
        public boolean isEnterpriseRuntime() {
            return this.serverDefinitionExtension.isEnterprise();
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public String getVersionSuffix() {
            return null;
        }

        @Override
        public String getVersionWithEESign() {
            return null;
        }

        @Override
        public String getDebuggerVersion() {
            return null;
        }

        @Override
        public String getVersionWithPatchVersionZero() {
            return null;
        }

        @Override
        public IPath getSourceFilePath() {
            return null;
        }

        @Override
        public IPath getEnterpriseSourceFilePath() {
            return null;
        }

        @Override
        public List<LibraryFolderDefinition> getLibraryFolders() {
            return null;
        }

        @Override
        public List<ConfigFolderDefinition> getConfigFolders() {
            return null;
        }

        @Override
        public ISchemaLocationLookup getSchemaLocationlookup() {
            return null;
        }

        @Override
        public String getVersionWithSuffix() {
            return null;
        }

        @Override
        public int getVersionNumber() {
            return 0;
        }

        @Override
        public List<ClasspathElementDefinition> getClasspathElements() {
            return null;
        }

        @Override
        public IPath getPluginBaseDirectory() {
            return null;
        }

        @Override
        public int compareVersionTo(String otherVersion) {
            return 0;
        }

        @Override
        public Collection<MuleLauncherClasspathElement> getMuleLauncherClasspathElements() {
            return null;
        }

        @Override
        public MuleLauncherClasspathElement getToolingSupportFolder() {
            return null;
        }

        @Override
        public MuleLauncherClasspathElement getEndorsedFolder() {
            return null;
        }

        @Override
        public MuleLauncherClasspathElement getMuleCorePerAppFolder() {
            return null;
        }

        @Override
        public LibraryFolderDefinition getMuleCoreLibrariesFolder() {
            return null;
        }

        @Override
        public LibraryFolderDefinition getLibraryFolderFolder(String label) {
            return null;
        }

        @Override
        public IMuleModuleManager getModuleManager() {
            return null;
        }

        @Override
        public RuntimeDefaultExtensions getRuntimeDefaultExtensions() {
            return null;
        }

        @Override
        public void setEnterpriseSourceFilePath(IPath path) {
        }

        @Override
        public int compareTo(IServerDefinition o) {
            return 0;
        }
    }
}

