/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server.defaultextensions.internal;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerFiltering;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.osgi.framework.Bundle;

@ExtensionPoint(extensionPointId="org.mule.tooling.runtime.defaults")
public class RuntimeDefaultExtensionsExtension
implements ServerFiltering {
    public static final String EXT_POINT_ID = "org.mule.tooling.runtime.defaults";
    private static final String KEY_ALL_DEFAULT_EXTENSIONS = "all";
    private static final String KEY_NEW_PROJECT_DEFAULT_EXTENSIONS = "new-project";
    private static final String DEPENDENCIES_SEPARATOR = ",";
    @Inject
    private Bundle bundle;
    @ExtensionAttribute
    private int priority = 0;
    @ExtensionAttribute
    private ServerMatcher targetRuntime;
    @ExtensionAttribute
    private String defaultExtensionsFilePath;

    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean matches(IServerDefinition server) {
        return this.targetRuntime.matches(server);
    }

    public List<MavenDependency> getDefaultExtensions() {
        Properties defaultsDefinitionProperties = this.loadDefaultsDefinitionFile();
        String defaultExtensionsString = defaultsDefinitionProperties.getProperty(KEY_ALL_DEFAULT_EXTENSIONS, "");
        return this.readDependencies(defaultExtensionsString);
    }

    public List<MavenDependency> getNewProjectDefaultExtensions() {
        Properties defaultsDefinitionProperties = this.loadDefaultsDefinitionFile();
        String newProjectExtensionsString = defaultsDefinitionProperties.getProperty(KEY_NEW_PROJECT_DEFAULT_EXTENSIONS, "");
        return this.readDependencies(newProjectExtensionsString);
    }

    private List<MavenDependency> readDependencies(String dependenciesString) {
        return Arrays.stream(dependenciesString.split(DEPENDENCIES_SEPARATOR)).map(String::trim).filter(StringUtils::isNotBlank).map(MavenUtils::getPluginDependency).collect(Collectors.toList());
    }

    private Properties loadDefaultsDefinitionFile() {
        Properties properties = new Properties();
        URL defaultsDefinitionUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.defaultExtensionsFilePath), null);
        if (defaultsDefinitionUrl != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream defaultsDefinitionStream = defaultsDefinitionUrl.openStream();){
                    properties.load(defaultsDefinitionStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logInvalidDefaultsPath(e);
            }
        } else {
            this.logInvalidDefaultsPath(new IllegalArgumentException("path " + this.defaultExtensionsFilePath + " could not be found in bundle " + this.bundle.getSymbolicName()).fillInStackTrace());
        }
        return properties;
    }

    private void logInvalidDefaultsPath(Throwable e) {
        MuleCorePlugin.logError("There was a problem reading default extensions definition from bundle " + this.bundle.getSymbolicName() + " in path " + this.defaultExtensionsFilePath + ". Using empty defaults.", e);
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setTargetRuntime(ServerMatcher targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public void setDefaultExtensionsFilePath(String defaultExtensionsFilePath) {
        this.defaultExtensionsFilePath = defaultExtensionsFilePath;
    }
}

